/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TypeUtils {
    public static final String NULLABLE_YES = "YES";
    public static final String NULLABLE_NO = "NO";
    private static final Pattern DECIMAL_PATTERN = Pattern.compile("Decimal\\(\\s*(\\d+)\\s*,\\s*(\\d+)\\s*\\)");

    public static int toSqlType(String clickhouseType) {
        if (TypeUtils.isNullable(clickhouseType)) {
            clickhouseType = TypeUtils.unwrapNullable(clickhouseType);
        }
        if (clickhouseType.startsWith("Int") || clickhouseType.startsWith("UInt")) {
            return clickhouseType.endsWith("64") ? -5 : 4;
        }
        if ("String".equals(clickhouseType)) {
            return 12;
        }
        if (clickhouseType.startsWith("Float32")) {
            return 6;
        }
        if (clickhouseType.startsWith("Float64")) {
            return 8;
        }
        if ("Date".equals(clickhouseType)) {
            return 91;
        }
        if ("DateTime".equals(clickhouseType)) {
            return 93;
        }
        if ("FixedString".equals(clickhouseType)) {
            return 2004;
        }
        if (TypeUtils.isArray(clickhouseType)) {
            return 2003;
        }
        if ("UUID".equals(clickhouseType)) {
            return 1111;
        }
        if (clickhouseType.startsWith("Decimal")) {
            return 3;
        }
        return 12;
    }

    public static String unwrapNullableIfApplicable(String clickhouseType) {
        return TypeUtils.isNullable(clickhouseType) ? TypeUtils.unwrapNullable(clickhouseType) : clickhouseType;
    }

    private static String unwrapNullable(String clickshouseType) {
        return clickshouseType.substring("Nullable(".length(), clickshouseType.length() - 1);
    }

    private static boolean isNullable(String clickshouseType) {
        return clickshouseType.startsWith("Nullable(") && clickshouseType.endsWith(")");
    }

    public static boolean isUnsigned(String clickhouseType) {
        if (TypeUtils.isNullable(clickhouseType)) {
            clickhouseType = TypeUtils.unwrapNullable(clickhouseType);
        }
        return clickhouseType.startsWith("UInt");
    }

    public static int[] supportedTypes() {
        return new int[]{-5, 4, 12, 6, 91, 93, 2004, 2003};
    }

    public static String getArrayElementTypeName(String clickhouseType) {
        if (!TypeUtils.isArray(clickhouseType)) {
            throw new IllegalArgumentException("not an array");
        }
        return clickhouseType.substring("Array(".length(), clickhouseType.length() - 1);
    }

    private static boolean isArray(String clickhouseType) {
        return clickhouseType.startsWith("Array(") && clickhouseType.endsWith(")");
    }

    public static Class toClass(int sqlType, boolean isUnsigned) throws SQLException {
        return TypeUtils.toClass(sqlType, -1, isUnsigned);
    }

    public static Class toClass(int sqlType, int elementSqltype, boolean isUnsigned) throws SQLException {
        switch (sqlType) {
            case -7: 
            case 16: {
                return Boolean.class;
            }
            case -6: 
            case 4: 
            case 5: {
                if (isUnsigned) {
                    return Long.class;
                }
                return Integer.class;
            }
            case -5: {
                if (isUnsigned) {
                    return BigInteger.class;
                }
                return Long.class;
            }
            case 8: {
                return Double.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2004: {
                return String.class;
            }
            case 6: 
            case 7: {
                return Float.class;
            }
            case 91: {
                return Date.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case 92: {
                return Time.class;
            }
            case 2003: {
                Class elementType = TypeUtils.toClass(elementSqltype, isUnsigned);
                return Array.newInstance(elementType, 0).getClass();
            }
        }
        throw new UnsupportedOperationException("Sql type " + sqlType + "is not supported");
    }

    public static int getColumnSize(String type) {
        if (TypeUtils.isNullable(type)) {
            type = TypeUtils.unwrapNullable(type);
        }
        if (type.equals("Float32")) {
            return 8;
        }
        if (type.equals("Float64")) {
            return 17;
        }
        if (type.equals("Int8")) {
            return 4;
        }
        if (type.equals("Int16")) {
            return 6;
        }
        if (type.equals("Int32")) {
            return 11;
        }
        if (type.equals("Int64")) {
            return 20;
        }
        if (type.equals("UInt8")) {
            return 3;
        }
        if (type.equals("UInt16")) {
            return 5;
        }
        if (type.equals("UInt32")) {
            return 10;
        }
        if (type.equals("UInt64")) {
            return 19;
        }
        if (type.equals("Date")) {
            return 10;
        }
        if (type.equals("DateTime")) {
            return 19;
        }
        if (type.startsWith("FixedString(")) {
            String numBytes = type.substring("FixedString(".length(), type.length() - 1);
            return Integer.parseInt(numBytes);
        }
        if (type.startsWith("Decimal(")) {
            Matcher m = DECIMAL_PATTERN.matcher(type);
            return m.matches() ? Integer.parseInt(m.group(1)) : 0;
        }
        return 0;
    }

    public static int getDecimalDigits(String type) {
        if (TypeUtils.isNullable(type)) {
            return TypeUtils.getDecimalDigits(TypeUtils.unwrapNullable(type));
        }
        if (type.equals("Float32")) {
            return 8;
        }
        if (type.equals("Float64")) {
            return 17;
        }
        Matcher m = DECIMAL_PATTERN.matcher(type);
        if (m.matches()) {
            return Integer.parseInt(m.group(2));
        }
        return 0;
    }

    public static String isTypeNull(String clickHouseType) {
        return TypeUtils.isNullable(clickHouseType) ? NULLABLE_YES : NULLABLE_NO;
    }
}

