/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.spring.webflux;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import lombok.Generated;
import org.springframework.util.MimeType;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.attributes.HttpAttributes;
import org.zalando.logbook.spring.webflux.State;

final class ClientRequest
implements HttpRequest {
    private final org.springframework.web.reactive.function.client.ClientRequest request;
    private final AtomicReference<State> state = new AtomicReference<State.Unbuffered>(new State.Unbuffered());

    public String getRemote() {
        return "localhost";
    }

    public String getMethod() {
        return this.request.method().name();
    }

    public String getScheme() {
        return Optional.of(this.request.url()).map(URI::getScheme).orElse("");
    }

    public String getHost() {
        return Optional.of(this.request.url()).map(URI::getHost).orElse("");
    }

    public Optional<Integer> getPort() {
        return Optional.of(this.request.url().getPort()).filter(p -> p != -1);
    }

    public String getPath() {
        return Optional.of(this.request.url()).map(URI::getPath).orElse("");
    }

    public String getQuery() {
        return Optional.of(this.request.url()).map(URI::getQuery).orElse("");
    }

    public Origin getOrigin() {
        return Origin.LOCAL;
    }

    public HttpHeaders getHeaders() {
        return HttpHeaders.of((Map)this.request.headers());
    }

    @Nullable
    public String getContentType() {
        return Optional.ofNullable(this.request.headers().getContentType()).map(MimeType::toString).orElse(null);
    }

    public Charset getCharset() {
        return Optional.ofNullable(this.request.headers().getContentType()).map(MimeType::getCharset).orElse(StandardCharsets.UTF_8);
    }

    public HttpRequest withBody() throws IOException {
        this.state.updateAndGet(State::with);
        return this;
    }

    public HttpRequest withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    boolean shouldBuffer() {
        return this.state.get() instanceof State.Offering;
    }

    void buffer(byte[] message) {
        this.state.updateAndGet(s -> s.buffer(message));
    }

    public byte[] getBody() throws IOException {
        return this.state.get().getBody();
    }

    public HttpAttributes getAttributes() {
        return new HttpAttributes(this.request.attributes());
    }

    @Generated
    public ClientRequest(org.springframework.web.reactive.function.client.ClientRequest request) {
        this.request = request;
    }
}

