/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ssssssss.script.annotation.Function;
import org.ssssssss.script.annotation.UnableCall;
import org.ssssssss.script.convert.BooleanImplicitConvert;
import org.ssssssss.script.convert.ClassImplicitConvert;
import org.ssssssss.script.convert.CollectionImplicitConvert;
import org.ssssssss.script.convert.FunctionalImplicitConvert;
import org.ssssssss.script.convert.MapImplicitConvert;
import org.ssssssss.script.functions.ArrayFunctions;
import org.ssssssss.script.functions.ClassExtension;
import org.ssssssss.script.functions.CollectionFunctions;
import org.ssssssss.script.functions.DateExtension;
import org.ssssssss.script.functions.MagicScriptFunctions;
import org.ssssssss.script.functions.MapExtension;
import org.ssssssss.script.functions.NumberExtension;
import org.ssssssss.script.functions.ObjectConvertExtension;
import org.ssssssss.script.functions.ObjectTypeConditionExtension;
import org.ssssssss.script.functions.PatternExtension;
import org.ssssssss.script.functions.StreamExtension;
import org.ssssssss.script.functions.StringExtension;
import org.ssssssss.script.functions.StringFunctions;
import org.ssssssss.script.functions.TemporalAccessorExtension;
import org.ssssssss.script.functions.linq.AggregationFunctions;
import org.ssssssss.script.functions.linq.LinqFunctions;
import org.ssssssss.script.functions.linq.MathFunctions;
import org.ssssssss.script.reflection.ConstructorInvoker;
import org.ssssssss.script.reflection.JavaInvoker;
import org.ssssssss.script.reflection.MethodInvoker;
import org.ssssssss.script.runtime.RuntimeContext;

public class JavaReflection {
    private static final Map<Class<?>, Map<String, Field>> FIELD_CACHE = new ConcurrentHashMap();
    private static final List<ClassImplicitConvert> CONVERTS = new ArrayList<ClassImplicitConvert>();
    private static final Map<Class<?>, Map<String, List<JavaInvoker<Method>>>> EXTENSION_METHOD_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Map<MethodSignature, JavaInvoker<Method>>> METHOD_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, List<Class<?>>> EXTENSION_MAP = new ConcurrentHashMap();
    private static final List<JavaInvoker<Method>> FUNCTIONS = new ArrayList<JavaInvoker<Method>>();

    public static void registerFunction(Object target) {
        Stream.of(target.getClass().getMethods()).filter(method -> method.getAnnotation(Function.class) != null).map(MethodInvoker::new).forEach(it -> {
            it.setDefaultTarget(target);
            FUNCTIONS.add((JavaInvoker<Method>)it);
        });
    }

    public static Map<Class<?>, List<Class<?>>> getExtensionMap() {
        return EXTENSION_MAP;
    }

    public static List<JavaInvoker<Method>> getFunctions() {
        return FUNCTIONS;
    }

    private static MethodInvoker findApply(Class<?> cls) {
        for (Method method : cls.getDeclaredMethods()) {
            if (!"apply".equals(method.getName())) continue;
            return new MethodInvoker(method);
        }
        return null;
    }

    private static int calcToObjectDistanceWithInterface(Class<?>[] interfaces, int distance, int score) {
        if (interfaces == null) {
            return distance;
        }
        return Arrays.stream(interfaces).mapToInt(i -> {
            int v = JavaReflection.calcToObjectDistanceWithInterface(i.getInterfaces(), distance, score + 2);
            return v + distance + score;
        }).sum();
    }

    private static int calcToObjectDistance(Class<?> clazz) {
        return JavaReflection.calcToObjectDistance(clazz, 0);
    }

    private static int calcToObjectDistance(Class<?> clazz, int distance) {
        if (clazz == null) {
            return distance + 3;
        }
        if (Object.class.equals(clazz)) {
            return distance;
        }
        int interfaceScore = JavaReflection.calcToObjectDistanceWithInterface(clazz.getInterfaces(), distance + 2, 0);
        if (clazz.isInterface()) {
            return interfaceScore;
        }
        int classScore = JavaReflection.calcToObjectDistance(clazz.getSuperclass(), distance + 3);
        return classScore + interfaceScore;
    }

    private static boolean isImplicitConvert(Class<?> from, Class<?> to) {
        if (JavaReflection.isPrimitiveAssignableFrom(from, from) || JavaReflection.isPrimitiveAssignableFrom(to, to)) {
            return false;
        }
        if (Collection.class.isAssignableFrom(to) || Iterator.class.isAssignableFrom(to) || Enumeration.class.isAssignableFrom(to) || to.isArray()) {
            Class<?> toClazz = JavaReflection.getGenericType(to);
            return toClazz != null && !JavaReflection.isPrimitiveAssignableFrom(toClazz, toClazz);
        }
        return Map.class.isAssignableFrom(from);
    }

    private static int matchTypes(JavaInvoker<?> invoker, Class<?>[] parameterTypes, Class<?>[] otherTypes, boolean matchCount) {
        if (matchCount && parameterTypes.length != otherTypes.length) {
            return -1;
        }
        int score = 0;
        int nn = parameterTypes.length;
        for (int ii = 0; ii < nn; ++ii) {
            Class<?> type = parameterTypes[ii];
            Class<?> otherType = otherTypes[ii];
            if (RuntimeContext.class.isAssignableFrom(otherType)) {
                score += 1000;
                continue;
            }
            if (Null.class.equals(type)) {
                if (otherType.isPrimitive()) {
                    score = -1;
                    break;
                }
                score += 1000;
                continue;
            }
            if (otherType.isAssignableFrom(type)) continue;
            score += 1000;
            if (JavaReflection.isPrimitiveAssignableFrom(type, otherType)) continue;
            score += 1000;
            if (JavaReflection.isCoercible(type, otherType)) continue;
            score += 2000;
            boolean found = false;
            for (ClassImplicitConvert convert : CONVERTS) {
                if (!convert.support(type, otherType)) continue;
                invoker.addClassImplicitConvert(ii, convert);
                found = true;
                break;
            }
            invoker.setImplicit(found);
            if (found) continue;
            return -1;
        }
        return score;
    }

    private static Class<?> getGenericType(Class<?> target) {
        Type type = target.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return null;
    }

    public static JavaInvoker<Method> findMethodInvoker(List<JavaInvoker<Method>> methods, Class<?>[] parameterTypes) {
        return JavaReflection.findInvoker(methods, parameterTypes);
    }

    public static JavaInvoker<Constructor> findConstructorInvoker(List<Constructor<?>> constructors, Class<?>[] parameterTypes) {
        return JavaReflection.findInvoker(constructors.stream().map(ConstructorInvoker::new).collect(Collectors.toList()), parameterTypes);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Executable> JavaInvoker<T> findInvoker(List<JavaInvoker<T>> executables, Class<?>[] parameterTypes) {
        int score;
        Class<?>[] otherTypes;
        JavaInvoker<T> foundInvoker = null;
        int foundScore = 0;
        ArrayList<JavaInvoker<T>> executableWithVarArgs = new ArrayList<JavaInvoker<T>>();
        for (JavaInvoker<T> javaInvoker : executables) {
            otherTypes = javaInvoker.getParameterTypes();
            JavaInvoker<T> javaInvoker2 = javaInvoker.copy();
            score = JavaReflection.matchTypes(javaInvoker2, parameterTypes, otherTypes, true);
            if (score > -1) {
                if (foundInvoker == null) {
                    foundInvoker = javaInvoker2;
                    foundScore = score;
                    continue;
                }
                if (score >= foundScore) continue;
                foundScore = score;
                foundInvoker = javaInvoker2;
                continue;
            }
            if (!javaInvoker2.isVarArgs()) continue;
            executableWithVarArgs.add(javaInvoker2);
        }
        if (foundInvoker == null) {
            for (JavaInvoker<Object> javaInvoker : executableWithVarArgs) {
                void var6_11;
                otherTypes = javaInvoker.getParameterTypes();
                score = -1;
                int fixedParaLength = otherTypes.length - 1;
                if (parameterTypes.length >= fixedParaLength) {
                    Class[] argTypes = new Class[fixedParaLength];
                    System.arraycopy(parameterTypes, 0, argTypes, 0, fixedParaLength);
                    JavaInvoker<Object> javaInvoker3 = javaInvoker.copy();
                    score = JavaReflection.matchTypes(javaInvoker3, argTypes, otherTypes, false);
                    if (score > -1) {
                        Class<?> target = otherTypes[fixedParaLength].getComponentType();
                        for (int i = fixedParaLength; i < parameterTypes.length; ++i) {
                            Class<?> type = parameterTypes[i];
                            if (RuntimeContext.class.isAssignableFrom(type)) {
                                ++score;
                                continue;
                            }
                            if (Null.class.equals(type)) {
                                if (!target.isPrimitive()) {
                                    ++score;
                                    continue;
                                }
                                score = -1;
                                break;
                            }
                            if (target.isAssignableFrom(type)) continue;
                            ++score;
                            if (JavaReflection.isPrimitiveAssignableFrom(type, target)) continue;
                            ++score;
                            if (!JavaReflection.isCoercible(type, target)) {
                                boolean found = false;
                                for (ClassImplicitConvert convert : CONVERTS) {
                                    if (!convert.support(type, target)) continue;
                                    javaInvoker3.addClassImplicitConvert(i, convert);
                                    found = true;
                                }
                                javaInvoker3.setImplicit(found);
                                if (!found) {
                                    score = -1;
                                    break;
                                }
                                ++score;
                                continue;
                            }
                            ++score;
                        }
                    }
                }
                if (score <= -1) continue;
                if (foundInvoker == null) {
                    foundInvoker = var6_11;
                    foundScore = score;
                    continue;
                }
                if (score >= foundScore) continue;
                foundScore = score;
                foundInvoker = var6_11;
            }
        }
        return foundInvoker;
    }

    public static JavaInvoker<Method> findInvoker(Class<?> cls, String name, Class<?>[] parameterTypes) {
        ArrayList<JavaInvoker<Method>> methodList = new ArrayList<JavaInvoker<Method>>();
        for (Method method : cls.getMethods()) {
            if (!method.getName().equals(name) || method.getAnnotation(UnableCall.class) != null || !Modifier.isPublic(method.getModifiers())) continue;
            methodList.add(new MethodInvoker(method));
        }
        return JavaReflection.findMethodInvoker(methodList, parameterTypes);
    }

    public static JavaInvoker<Method> findInvoker(Class<?> cls, String name) {
        return JavaReflection.findInvoker(cls, name, new Class[0]);
    }

    public static boolean isPrimitiveAssignableFrom(Class<?> from, Class<?> to) {
        if (!(from != Boolean.class && from != Boolean.TYPE || to != Boolean.TYPE && to != Boolean.class)) {
            return true;
        }
        if (!(from != Integer.class && from != Integer.TYPE || to != Integer.TYPE && to != Integer.class)) {
            return true;
        }
        if (!(from != Float.class && from != Float.TYPE || to != Float.TYPE && to != Float.class)) {
            return true;
        }
        if (!(from != Double.class && from != Double.TYPE || to != Double.TYPE && to != Double.class)) {
            return true;
        }
        if (!(from != Byte.class && from != Byte.TYPE || to != Byte.TYPE && to != Byte.class)) {
            return true;
        }
        if (!(from != Short.class && from != Short.TYPE || to != Short.TYPE && to != Short.class)) {
            return true;
        }
        if (!(from != Long.class && from != Long.TYPE || to != Long.TYPE && to != Long.class)) {
            return true;
        }
        return !(from != Character.class && from != Character.TYPE || to != Character.TYPE && to != Character.class);
    }

    public static String[] getStringTypes(Object[] objects) {
        String[] parameterTypes = new String[objects == null ? 0 : objects.length];
        if (objects != null) {
            for (Object value : objects) {
                parameterTypes[i] = value == null ? "null" : value.getClass().getSimpleName();
            }
        }
        return parameterTypes;
    }

    private static boolean isCoercible(Class<?> from, Class<?> to) {
        if (from == Integer.class || from == Integer.TYPE) {
            return to == Float.TYPE || to == Float.class || to == Double.TYPE || to == Double.class || to == Long.TYPE || to == Long.class;
        }
        if (from == Float.class || from == Float.TYPE) {
            return to == Double.TYPE || to == Double.class;
        }
        if (from == Double.class || from == Double.TYPE) {
            return false;
        }
        if (from == Character.class || from == Character.TYPE) {
            return to == Integer.TYPE || to == Integer.class || to == Float.TYPE || to == Float.class || to == Double.TYPE || to == Double.class || to == Long.TYPE || to == Long.class;
        }
        if (from == Byte.class || from == Byte.TYPE) {
            return to == Integer.TYPE || to == Integer.class || to == Float.TYPE || to == Float.class || to == Double.TYPE || to == Double.class || to == Long.TYPE || to == Long.class || to == Short.TYPE || to == Short.class;
        }
        if (from == Short.class || from == Short.TYPE) {
            return to == Integer.TYPE || to == Integer.class || to == Float.TYPE || to == Float.class || to == Double.TYPE || to == Double.class || to == Long.TYPE || to == Long.class;
        }
        if (from == Long.class || from == Long.TYPE) {
            return to == Float.TYPE || to == Float.class || to == Double.TYPE || to == Double.class;
        }
        if (from == int[].class || from == Integer[].class) {
            return to == Object[].class || to == float[].class || to == Float[].class || to == double[].class || to == Double[].class || to == long[].class || to == Long[].class;
        }
        return false;
    }

    public static Object getInnerClass(Object obj, String name) {
        Class<?> cls = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        for (Class<?> clazz : cls.getDeclaredClasses()) {
            if (!name.equalsIgnoreCase(clazz.getSimpleName())) continue;
            return clazz;
        }
        return null;
    }

    public static Field getField(Object obj, String name) {
        Field field;
        Class<?> cls = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        Map<String, Field> fields = FIELD_CACHE.get(cls);
        if (fields == null) {
            fields = new ConcurrentHashMap<String, Field>();
            FIELD_CACHE.put(cls, fields);
        }
        if ((field = fields.get(name)) == null) {
            try {
                field = cls.getDeclaredField(name);
                if (field.getAnnotation(UnableCall.class) != null) {
                    field = null;
                } else {
                    field.setAccessible(true);
                    fields.put(name, field);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (field == null) {
                for (Class<?> parentClass = cls.getSuperclass(); parentClass != Object.class && parentClass != null; parentClass = parentClass.getSuperclass()) {
                    try {
                        field = parentClass.getDeclaredField(name);
                        if (field.getAnnotation(UnableCall.class) != null) {
                            field = null;
                            continue;
                        }
                        field.setAccessible(true);
                        fields.put(name, field);
                        continue;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
            }
        }
        return field;
    }

    public static void registerImplicitConvert(ClassImplicitConvert classImplicitConvert) {
        CONVERTS.add(classImplicitConvert);
    }

    public static void registerMethodExtension(Class<?> target, Object extensionObject) {
        List<Class<?>> classList = EXTENSION_MAP.get(target);
        if (classList == null) {
            classList = new ArrayList();
            EXTENSION_MAP.put(target, classList);
        }
        Class<?> clazz = extensionObject.getClass();
        classList.add(clazz);
        Method[] methods = clazz.getDeclaredMethods();
        if (methods != null) {
            Map<String, List<JavaInvoker<Method>>> cachedMethodMap = EXTENSION_METHOD_CACHE.get(target);
            if (cachedMethodMap == null) {
                cachedMethodMap = new HashMap<String, List<JavaInvoker<Method>>>();
                EXTENSION_METHOD_CACHE.put(target, cachedMethodMap);
            }
            for (Method method : methods) {
                if (!Modifier.isPublic(method.getModifiers()) || method.getParameterCount() <= 0 || method.getAnnotation(UnableCall.class) != null) continue;
                List<JavaInvoker<Method>> cachedList = cachedMethodMap.get(method.getName());
                if (cachedList == null) {
                    cachedList = new ArrayList<JavaInvoker<Method>>();
                    cachedMethodMap.put(method.getName(), cachedList);
                }
                cachedList.add(new MethodInvoker(method, extensionObject));
            }
            Collection<List<JavaInvoker<Method>>> methodsValues = cachedMethodMap.values();
            for (List<JavaInvoker<Method>> methodList : methodsValues) {
                methodList.sort((m1, m2) -> {
                    int sum1 = Arrays.stream(m1.getParameterTypes()).mapToInt(JavaReflection::calcToObjectDistance).sum();
                    int sum2 = Arrays.stream(m2.getParameterTypes()).mapToInt(JavaReflection::calcToObjectDistance).sum();
                    return sum2 - sum1;
                });
            }
        }
    }

    public static Object getFieldValue(Object obj, Field field) {
        try {
            return field.get(obj);
        }
        catch (Throwable e) {
            throw new RuntimeException("Couldn't get value of field '" + field.getName() + "' from object of type '" + obj.getClass().getSimpleName() + "'");
        }
    }

    public static void setFieldValue(Object obj, Field field, Object value) {
        try {
            field.set(obj, value);
        }
        catch (Throwable e) {
            throw new RuntimeException("Couldn't set value of field '" + field.getName() + "' from object of type '" + obj.getClass().getSimpleName() + "'");
        }
    }

    public static JavaInvoker<Method> getExtensionMethod(Object obj, String name, Object ... arguments) {
        Class cls;
        boolean isClass = obj instanceof Class;
        Class clazz = cls = isClass ? Class.class : obj.getClass();
        if (cls.isArray()) {
            cls = Object[].class;
        }
        return JavaReflection.getExtensionMethod(cls, name, arguments);
    }

    private static Class[] getParameterTypes(Class<?> cls, Object ... arguments) {
        int begin = cls == null ? 0 : 1;
        Class[] parameterTypes = new Class[arguments.length + begin];
        if (begin > 0) {
            parameterTypes[0] = cls;
        }
        for (int i = 0; i < arguments.length; ++i) {
            parameterTypes[i + begin] = arguments[i] == null ? Null.class : arguments[i].getClass();
        }
        return parameterTypes;
    }

    private static JavaInvoker<Method> getExtensionMethod(Class<?> cls, String name, Object ... arguments) {
        List<JavaInvoker<Method>> methodList;
        Map<String, List<JavaInvoker<Method>>> methodMap;
        if (cls == null) {
            cls = Object.class;
        }
        if ((methodMap = EXTENSION_METHOD_CACHE.get(cls)) != null && (methodList = methodMap.get(name)) != null) {
            return JavaReflection.findMethodInvoker(methodList, JavaReflection.getParameterTypes(cls, arguments));
        }
        if (cls != Object.class) {
            Class<?>[] interfaces = cls.getInterfaces();
            if (interfaces != null) {
                for (Class<?> clazz : interfaces) {
                    JavaInvoker<Method> invoker = JavaReflection.getExtensionMethod(clazz, name, arguments);
                    if (invoker == null) continue;
                    return invoker;
                }
            }
            return JavaReflection.getExtensionMethod(cls.getSuperclass(), name, arguments);
        }
        return null;
    }

    public static JavaInvoker<Method> getMethod(Object obj, String name, Object ... arguments) {
        JavaInvoker<Method> extensionInvoker;
        Class[] parameterTypes;
        MethodSignature signature;
        JavaInvoker invoker;
        boolean isClass = obj instanceof Class;
        Class cls = isClass ? (Class)obj : (obj instanceof java.util.function.Function ? java.util.function.Function.class : obj.getClass());
        Map<MethodSignature, JavaInvoker<Method>> methods = METHOD_CACHE.get(cls);
        if (methods == null) {
            methods = new ConcurrentHashMap<MethodSignature, JavaInvoker<Method>>();
            METHOD_CACHE.put(cls, methods);
        }
        if ((invoker = methods.get(signature = new MethodSignature(name, parameterTypes = JavaReflection.getParameterTypes(null, arguments)))) == null) {
            try {
                if (name == null) {
                    invoker = JavaReflection.findApply(cls);
                } else {
                    invoker = JavaReflection.findInvoker(cls, name, parameterTypes);
                    if (invoker == null) {
                        invoker = JavaReflection.findInvoker(cls, name, new Class[]{Object[].class});
                    }
                }
                methods.put(signature, invoker);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (invoker == null) {
                for (Class parentClass = cls.getSuperclass(); parentClass != null; parentClass = parentClass.getSuperclass()) {
                    try {
                        invoker = name == null ? JavaReflection.findApply(parentClass) : JavaReflection.findInvoker(parentClass, name, parameterTypes);
                        methods.put(signature, invoker);
                        if (invoker == null) continue;
                        break;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        if ((invoker == null || invoker.isImplicit()) && (extensionInvoker = JavaReflection.getExtensionMethod(obj, name, arguments)) != null) {
            extensionInvoker.setExtension(true);
            invoker = extensionInvoker;
        }
        return invoker;
    }

    public static JavaInvoker<Method> getFunction(String name, Object ... arguments) {
        List<JavaInvoker<Method>> methodList = FUNCTIONS.stream().filter(it -> ((Method)it.getExecutable()).getName().equals(name)).collect(Collectors.toList());
        return JavaReflection.findMethodInvoker(methodList, JavaReflection.getParameterTypes(null, arguments));
    }

    static {
        JavaReflection.registerMethodExtension(Class.class, new ClassExtension());
        StreamExtension streamExtension = new StreamExtension();
        JavaReflection.registerMethodExtension(Collection.class, streamExtension);
        JavaReflection.registerMethodExtension(Object[].class, streamExtension);
        JavaReflection.registerMethodExtension(Enumeration.class, streamExtension);
        JavaReflection.registerMethodExtension(Iterator.class, streamExtension);
        JavaReflection.registerMethodExtension(Object.class, new ObjectConvertExtension());
        JavaReflection.registerMethodExtension(Object.class, new ObjectTypeConditionExtension());
        JavaReflection.registerMethodExtension(Map.class, new MapExtension());
        JavaReflection.registerMethodExtension(Date.class, new DateExtension());
        JavaReflection.registerMethodExtension(TemporalAccessorExtension.class, new TemporalAccessorExtension());
        JavaReflection.registerMethodExtension(Number.class, new NumberExtension());
        JavaReflection.registerMethodExtension(Pattern.class, new PatternExtension());
        JavaReflection.registerMethodExtension(String.class, new StringExtension());
        JavaReflection.registerImplicitConvert(new MapImplicitConvert());
        JavaReflection.registerImplicitConvert(new CollectionImplicitConvert());
        JavaReflection.registerImplicitConvert(new FunctionalImplicitConvert());
        JavaReflection.registerImplicitConvert(new BooleanImplicitConvert());
        JavaReflection.registerFunction(new AggregationFunctions());
        JavaReflection.registerFunction(new LinqFunctions());
        JavaReflection.registerFunction(new CollectionFunctions());
        JavaReflection.registerFunction(new MathFunctions());
        JavaReflection.registerFunction(new StringFunctions());
        JavaReflection.registerFunction(new MagicScriptFunctions());
        JavaReflection.registerFunction(new ArrayFunctions());
    }

    private static class MethodSignature {
        private final String name;
        private final Class[] parameters;
        private final int hashCode;

        MethodSignature(String name, Class[] parameters) {
            this.name = name;
            this.parameters = parameters;
            int prime = 31;
            int hash = 1;
            hash = 31 * hash + (name == null ? 0 : name.hashCode());
            this.hashCode = hash = 31 * hash + Arrays.hashCode(parameters);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodSignature other = (MethodSignature)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return Arrays.equals(this.parameters, other.parameters);
        }
    }

    public static final class Null {
    }
}

