/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.MagicScriptEngine;
import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.compile.CompileCache;
import org.ssssssss.script.compile.MagicScriptCompileException;
import org.ssssssss.script.compile.MagicScriptCompiler;
import org.ssssssss.script.exception.MagicExitException;
import org.ssssssss.script.exception.MagicScriptException;
import org.ssssssss.script.functions.DynamicModuleImport;
import org.ssssssss.script.parsing.Parser;
import org.ssssssss.script.parsing.VarIndex;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.Node;
import org.ssssssss.script.parsing.ast.statement.Import;
import org.ssssssss.script.parsing.ast.statement.Return;
import org.ssssssss.script.parsing.ast.statement.VariableAccess;
import org.ssssssss.script.runtime.MagicScriptClassLoader;
import org.ssssssss.script.runtime.MagicScriptRuntime;
import org.ssssssss.script.runtime.MagicScriptVariableAccessRuntime;

public class MagicScript
extends CompiledScript {
    public static final String CONTEXT_ROOT = "ROOT";
    public static final String DEBUG_MARK = "!# DEBUG\r\n";
    private final List<Node> nodes;
    private final ScriptEngine scriptEngine;
    private final Set<VarIndex> varIndices;
    private MagicScriptRuntime runtime;
    private Constructor<MagicScriptRuntime> constructor;
    private final boolean debug;
    private static CompileCache compileCache;

    private MagicScript(List<Node> nodes, Set<VarIndex> varIndices, ScriptEngine scriptEngine, boolean debug) {
        this.nodes = nodes;
        this.varIndices = varIndices;
        this.scriptEngine = scriptEngine;
        this.debug = debug;
    }

    public static void setCompileCache(int capacity) {
        compileCache = new CompileCache(capacity);
    }

    public static MagicScript create(String source, ScriptEngine scriptEngine) {
        return MagicScript.create(false, source, scriptEngine);
    }

    public static MagicScript create(boolean expression, String source, ScriptEngine scriptEngine) {
        if (compileCache == null) {
            compileCache = new CompileCache(500);
        }
        return compileCache.get(source, () -> {
            Parser parser = new Parser();
            boolean debug = source.startsWith(DEBUG_MARK);
            String script = debug ? source.substring(DEBUG_MARK.length()) : source;
            List<Node> nodes = parser.parse(expression ? "return " + script : script);
            Set<VarIndex> varIndices = parser.getVarIndices();
            return new MagicScript(nodes, varIndices, scriptEngine, debug);
        });
    }

    public Object execute(MagicScriptContext context) {
        try {
            MagicScriptEngine.getDefaultImports().forEach((name, value) -> {
                if (value instanceof DynamicModuleImport) {
                    context.set((String)name, ((DynamicModuleImport)value).getDynamicModule(context));
                } else {
                    context.set((String)name, value);
                }
            });
            return this.compile().execute(context);
        }
        catch (MagicExitException e) {
            return e.getExitValue();
        }
        catch (MagicScriptCompileException e) {
            throw e;
        }
        catch (Throwable t) {
            MagicScriptError.transfer(this.runtime, t);
            return null;
        }
    }

    public MagicScriptRuntime compile() throws MagicScriptCompileException {
        Return returnNode;
        if (this.runtime != null) {
            return this.buildRuntime();
        }
        if (this.nodes.size() == 1 && this.nodes.get(0) instanceof Return && (returnNode = (Return)this.nodes.get(0)).getReturnValue() instanceof VariableAccess) {
            this.runtime = new MagicScriptVariableAccessRuntime(((VariableAccess)returnNode.getReturnValue()).getVarIndex().getName());
            return this.runtime;
        }
        try {
            MagicScriptCompiler compiler = new MagicScriptCompiler(this.varIndices, this.debug);
            this.nodes.forEach(node -> node.visitMethod(compiler));
            if (this.nodes.size() == 1 && this.nodes.get(0) instanceof Expression) {
                Node node2 = this.nodes.get(0);
                compiler.loadVars();
                compiler.compile(new Return(node2.getSpan(), node2));
            } else {
                Map<Boolean, List<Node>> nodeMap = this.nodes.stream().collect(Collectors.partitioningBy(it -> it instanceof Import && ((Import)it).isImportPackage()));
                compiler.compile(nodeMap.get(Boolean.TRUE));
                compiler.loadVars();
                compiler.compile(nodeMap.get(Boolean.FALSE));
            }
            Class<MagicScriptRuntime> clazz = new MagicScriptClassLoader(Thread.currentThread().getContextClassLoader()).load(compiler.getClassName(), compiler.bytecode());
            this.constructor = clazz.getConstructor(new Class[0]);
            this.runtime = this.constructor.newInstance(new Object[0]);
            this.runtime.setVarNames((String[])this.varIndices.stream().map(VarIndex::getName).toArray(String[]::new));
            this.runtime.setSpans(compiler.getSpans());
            return this.runtime;
        }
        catch (MagicScriptException mse) {
            throw new MagicScriptCompileException(mse.getSimpleMessage(), mse);
        }
        catch (MagicScriptCompileException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MagicScriptCompileException(e);
        }
    }

    private MagicScriptRuntime buildRuntime() {
        if (this.constructor == null) {
            return this.runtime;
        }
        try {
            MagicScriptRuntime target = this.constructor.newInstance(new Object[0]);
            target.setVarNames(this.runtime.getVarNames());
            target.setSpans(this.runtime.getSpans());
            return target;
        }
        catch (Exception e) {
            throw new MagicScriptCompileException(e);
        }
    }

    @Override
    public Object eval(ScriptContext context) {
        Bindings bindings = context.getBindings(100);
        if (bindings.containsKey(CONTEXT_ROOT)) {
            Object root = bindings.get(CONTEXT_ROOT);
            if (root instanceof MagicScriptContext) {
                MagicScriptContext rootContext = (MagicScriptContext)root;
                return this.execute(rootContext);
            }
            throw new MagicScriptException("\u53c2\u6570\u4e0d\u6b63\u786e\uff01");
        }
        MagicScriptContext magicScriptContext = new MagicScriptContext();
        magicScriptContext.putMapIntoContext(context.getBindings(200));
        magicScriptContext.putMapIntoContext(context.getBindings(100));
        return this.execute(magicScriptContext);
    }

    @Override
    public ScriptEngine getEngine() {
        return this.scriptEngine;
    }
}

