/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.MagicScriptEngine;
import org.ssssssss.script.ScriptClass;
import org.ssssssss.script.exception.ModuleNotFoundException;
import org.ssssssss.script.functions.DynamicModuleImport;

public class MagicResourceLoader {
    private static final Set<String> PACKAGES = new HashSet<String>();
    private static final List<BiFunction<MagicScriptContext, String, Object>> FUNCTION_LOADERS = new ArrayList<BiFunction<MagicScriptContext, String, Object>>();
    private static final List<Function<String, BiFunction<Map<String, Object>, String, Object>>> SCRIPT_LANGUAGE_LOADERS = new ArrayList<Function<String, BiFunction<Map<String, Object>, String, Object>>>();
    private static Map<String, Object> MODULES = new ConcurrentHashMap<String, Object>();
    private static Function<String, Object> classLoader = className -> {
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            return null;
        }
    };

    public static Map<String, ScriptClass> getModules() {
        return MODULES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            ScriptClass scriptClass;
            if (entry.getValue() instanceof Class) {
                Class clazz = (Class)entry.getValue();
                scriptClass = MagicScriptEngine.getScriptClassFromClass(clazz);
            } else if (entry.getValue() instanceof DynamicModuleImport) {
                DynamicModuleImport dmi = (DynamicModuleImport)entry.getValue();
                scriptClass = MagicScriptEngine.getScriptClassFromClass(dmi.getTargetClass());
            } else {
                scriptClass = MagicScriptEngine.getScriptClassFromClass(entry.getValue().getClass());
            }
            scriptClass.setModule(true);
            return scriptClass;
        }));
    }

    public static void addFunctionLoader(BiFunction<MagicScriptContext, String, Object> functionLoader) {
        FUNCTION_LOADERS.add(functionLoader);
    }

    public static void setClassLoader(Function<String, Object> classLoader) {
        MagicResourceLoader.classLoader = classLoader;
    }

    public static void addModule(String moduleName, Object target) {
        MODULES.put(moduleName, target);
    }

    public static Object loadModule(MagicScriptContext context, String moduleName) {
        return MagicResourceLoader.loadModule(moduleName);
    }

    public static Object loadModule(String moduleName) {
        Object module = MODULES.get(moduleName);
        if (module == null) {
            throw new ModuleNotFoundException("\u627e\u4e0d\u5230\u6a21\u5757\uff1a" + moduleName);
        }
        return module;
    }

    public static Object loadClass(MagicScriptContext context, String className) {
        return classLoader.apply(className);
    }

    public static Set<String> getModuleNames() {
        return MODULES.keySet();
    }

    public static void addPackage(String prefix) {
        PACKAGES.add(prefix.replace("*", ""));
    }

    public static Class<?> findClass(String simpleName) {
        for (String prefix : PACKAGES) {
            try {
                return Class.forName(prefix + simpleName);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static void addScriptLanguageLoader(Function<String, BiFunction<Map<String, Object>, String, Object>> loader) {
        SCRIPT_LANGUAGE_LOADERS.add(loader);
    }

    public static BiFunction<Map<String, Object>, String, Object> loadScriptLanguage(String name) {
        for (Function<String, BiFunction<Map<String, Object>, String, Object>> languageLoader : SCRIPT_LANGUAGE_LOADERS) {
            try {
                BiFunction<Map<String, Object>, String, Object> function = languageLoader.apply(name);
                if (function == null) continue;
                return function;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static Object loadFunction(MagicScriptContext context, String name) {
        for (BiFunction<MagicScriptContext, String, Object> loader : FUNCTION_LOADERS) {
            try {
                Object value = loader.apply(context, name);
                if (value == null) continue;
                return value;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    static {
        MagicResourceLoader.addPackage("java.util.*");
        MagicResourceLoader.addPackage("java.lang.*");
    }
}

