/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.assertj;

import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.test.http.HttpHeadersAssert;
import org.springframework.test.http.MediaTypeAssert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.function.SingletonSupplier;

public abstract class AbstractHttpServletResponseAssert<R extends HttpServletResponse, SELF extends AbstractHttpServletResponseAssert<R, SELF, ACTUAL>, ACTUAL>
extends AbstractObjectAssert<SELF, ACTUAL> {
    private final Supplier<MediaTypeAssert> contentTypeAssertSupplier = SingletonSupplier.of(() -> new MediaTypeAssert(this.getResponse().getContentType()));
    private final Supplier<HttpHeadersAssert> headersAssertSupplier = SingletonSupplier.of(() -> new HttpHeadersAssert(AbstractHttpServletResponseAssert.getHttpHeaders(this.getResponse())));
    private final Supplier<AbstractIntegerAssert<?>> statusAssert = SingletonSupplier.of(() -> (AbstractIntegerAssert)Assertions.assertThat((int)this.getResponse().getStatus()).as("HTTP status code", new Object[0]));

    protected AbstractHttpServletResponseAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    private static HttpHeaders getHttpHeaders(HttpServletResponse response) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        response.getHeaderNames().forEach(arg_0 -> AbstractHttpServletResponseAssert.lambda$getHttpHeaders$0((MultiValueMap)headers, response, arg_0));
        return new HttpHeaders((MultiValueMap)headers);
    }

    protected abstract R getResponse();

    public MediaTypeAssert contentType() {
        return this.contentTypeAssertSupplier.get();
    }

    public HttpHeadersAssert headers() {
        return this.headersAssertSupplier.get();
    }

    public SELF hasContentType(MediaType contentType) {
        this.contentType().isEqualTo(contentType);
        return (SELF)((Object)((AbstractHttpServletResponseAssert)this.myself));
    }

    public SELF hasContentType(String contentType) {
        this.contentType().isEqualTo(contentType);
        return (SELF)((Object)((AbstractHttpServletResponseAssert)this.myself));
    }

    public SELF hasContentTypeCompatibleWith(MediaType contentType) {
        this.contentType().isCompatibleWith(contentType);
        return (SELF)((Object)((AbstractHttpServletResponseAssert)this.myself));
    }

    public SELF hasContentTypeCompatibleWith(String contentType) {
        this.contentType().isCompatibleWith(contentType);
        return (SELF)((Object)((AbstractHttpServletResponseAssert)this.myself));
    }

    public SELF containsHeader(String name) {
        this.headers().containsHeader(name);
        return (SELF)((Object)((AbstractHttpServletResponseAssert)this.myself));
    }

    public SELF doesNotContainHeader(String name) {
        this.headers().doesNotContainHeader(name);
        return (SELF)((Object)((AbstractHttpServletResponseAssert)this.myself));
    }

    public SELF hasHeader(String name, String value) {
        this.headers().hasValue(name, value);
        return (SELF)((Object)((AbstractHttpServletResponseAssert)this.myself));
    }

    public SELF hasStatus(int status) {
        this.status().isEqualTo(status);
        return (SELF)((Object)((AbstractHttpServletResponseAssert)this.myself));
    }

    public SELF hasStatus(HttpStatus status) {
        return this.hasStatus(status.value());
    }

    public SELF hasStatusOk() {
        return this.hasStatus(HttpStatus.OK);
    }

    public SELF hasStatus1xxInformational() {
        return this.hasStatusSeries(HttpStatus.Series.INFORMATIONAL);
    }

    public SELF hasStatus2xxSuccessful() {
        return this.hasStatusSeries(HttpStatus.Series.SUCCESSFUL);
    }

    public SELF hasStatus3xxRedirection() {
        return this.hasStatusSeries(HttpStatus.Series.REDIRECTION);
    }

    public SELF hasStatus4xxClientError() {
        return this.hasStatusSeries(HttpStatus.Series.CLIENT_ERROR);
    }

    public SELF hasStatus5xxServerError() {
        return this.hasStatusSeries(HttpStatus.Series.SERVER_ERROR);
    }

    private SELF hasStatusSeries(HttpStatus.Series series) {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)HttpStatus.Series.resolve((int)this.getResponse().getStatus())).as("HTTP status series", new Object[0])).isEqualTo((Object)series);
        return (SELF)((Object)((AbstractHttpServletResponseAssert)this.myself));
    }

    private AbstractIntegerAssert<?> status() {
        return this.statusAssert.get();
    }

    private static /* synthetic */ void lambda$getHttpHeaders$0(MultiValueMap headers, HttpServletResponse response, String name) {
        headers.put((Object)name, new ArrayList(response.getHeaders(name)));
    }
}

