/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.support;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.integration.kafka.support.ConsumerConfiguration;
import org.springframework.integration.kafka.support.ZookeeperConnect;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.CollectionUtils;

public class KafkaConsumerContext<K, V>
implements DisposableBean {
    private Map<String, ConsumerConfiguration<K, V>> consumerConfigurations;
    private String consumerTimeout = "5000";
    private ZookeeperConnect zookeeperConnect;

    public String getConsumerTimeout() {
        return this.consumerTimeout;
    }

    public void setConsumerTimeout(String consumerTimeout) {
        this.consumerTimeout = consumerTimeout;
    }

    public ZookeeperConnect getZookeeperConnect() {
        return this.zookeeperConnect;
    }

    public void setZookeeperConnect(ZookeeperConnect zookeeperConnect) {
        this.zookeeperConnect = zookeeperConnect;
    }

    public void setConsumerConfigurations(Map<String, ConsumerConfiguration<K, V>> consumerConfigurations) {
        this.consumerConfigurations = consumerConfigurations;
    }

    public Map<String, ConsumerConfiguration<K, V>> getConsumerConfigurations() {
        return this.consumerConfigurations;
    }

    public ConsumerConfiguration<K, V> getConsumerConfiguration(String groupId) {
        return this.consumerConfigurations.get(groupId);
    }

    public Message<Map<String, Map<Integer, List<Object>>>> receive() {
        HashMap<String, Map<Integer, List<Object>>> consumedData = new HashMap<String, Map<Integer, List<Object>>>();
        for (ConsumerConfiguration<K, V> consumerConfiguration : this.getConsumerConfigurations().values()) {
            Map<String, Map<Integer, List<Object>>> messages = consumerConfiguration.receive();
            if (CollectionUtils.isEmpty(messages)) continue;
            consumedData.putAll(messages);
        }
        return consumedData.isEmpty() ? null : MessageBuilder.withPayload(consumedData).build();
    }

    public void destroy() throws Exception {
        for (ConsumerConfiguration<K, V> config : this.consumerConfigurations.values()) {
            config.shutdown();
        }
    }
}

