/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.junit4.runner;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.gen5.launcher.TestIdentifier;
import org.junit.gen5.launcher.TestPlan;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

class JUnit5TestTree {
    private final Map<TestIdentifier, Description> descriptions = new HashMap<TestIdentifier, Description>();
    private final TestPlan plan;
    private final Description suiteDescription;

    JUnit5TestTree(TestPlan plan, Class<?> testClass) {
        this.plan = plan;
        this.suiteDescription = this.generateDescription(plan, testClass);
    }

    Description getSuiteDescription() {
        return this.suiteDescription;
    }

    Description getDescription(TestIdentifier identifier) {
        return this.descriptions.get(identifier);
    }

    private Description generateDescription(TestPlan testPlan, Class<?> testClass) {
        Description suiteDescription = Description.createSuiteDescription((String)testClass.getName(), (Annotation[])new Annotation[0]);
        this.buildDescriptionTree(suiteDescription, testPlan);
        return suiteDescription;
    }

    private void buildDescriptionTree(Description suiteDescription, TestPlan testPlan) {
        testPlan.getRoots().stream().forEach(testIdentifier -> this.buildDescription((TestIdentifier)testIdentifier, suiteDescription, testPlan));
    }

    private void buildDescription(TestIdentifier identifier, Description parent, TestPlan testPlan) {
        Description newDescription = this.createJUnit4Description(identifier, testPlan);
        parent.addChild(newDescription);
        this.descriptions.put(identifier, newDescription);
        testPlan.getChildren(identifier).stream().forEach(testIdentifier -> this.buildDescription((TestIdentifier)testIdentifier, newDescription, testPlan));
    }

    private Description createJUnit4Description(TestIdentifier identifier, TestPlan testPlan) {
        if (identifier.isTest()) {
            return Description.createTestDescription((String)testPlan.getParent(identifier).orElse(identifier).getDisplayName(), (String)identifier.getDisplayName(), (Serializable)identifier.getUniqueId());
        }
        return Description.createSuiteDescription((String)identifier.getDisplayName(), (Serializable)identifier.getUniqueId(), (Annotation[])new Annotation[0]);
    }

    Set<TestIdentifier> getTestsInSubtree(TestIdentifier ancestor) {
        return this.plan.getDescendants(ancestor).stream().filter(TestIdentifier::isTest).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    Set<TestIdentifier> getFilteredLeaves(Filter filter) {
        Set<TestIdentifier> identifiers = this.applyFilterToDescriptions(filter);
        return this.removeNonLeafIdentifiers(identifiers);
    }

    private Set<TestIdentifier> removeNonLeafIdentifiers(Set<TestIdentifier> identifiers) {
        return identifiers.stream().filter(this.isALeaf(identifiers)).collect(Collectors.toSet());
    }

    private Predicate<? super TestIdentifier> isALeaf(Set<TestIdentifier> identifiers) {
        return testIdentifier -> {
            Set descendants = this.plan.getDescendants(testIdentifier);
            return identifiers.stream().noneMatch(descendants::contains);
        };
    }

    private Set<TestIdentifier> applyFilterToDescriptions(Filter filter) {
        return this.descriptions.entrySet().stream().filter(entry -> filter.shouldRun((Description)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }
}

