/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.junit4.runner;

import org.junit.gen5.engine.TestExecutionResult;
import org.junit.gen5.engine.reporting.ReportEntry;
import org.junit.gen5.junit4.runner.JUnit5TestTree;
import org.junit.gen5.launcher.TestExecutionListener;
import org.junit.gen5.launcher.TestIdentifier;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

class JUnit5RunnerListener
implements TestExecutionListener {
    private final JUnit5TestTree testTree;
    private final RunNotifier notifier;

    JUnit5RunnerListener(JUnit5TestTree testTree, RunNotifier notifier) {
        this.testTree = testTree;
        this.notifier = notifier;
    }

    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        System.err.println("JUnit5 Runner does not support dynamic tests.");
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (testIdentifier.isTest()) {
            this.fireTestIgnored(testIdentifier);
        } else {
            this.testTree.getTestsInSubtree(testIdentifier).forEach(this::fireTestIgnored);
        }
    }

    private void fireTestIgnored(TestIdentifier testIdentifier) {
        Description description = this.findJUnit4Description(testIdentifier);
        this.notifier.fireTestIgnored(description);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isTest()) {
            Description description = this.findJUnit4Description(testIdentifier);
            this.notifier.fireTestStarted(description);
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        Description description = this.findJUnit4Description(testIdentifier);
        TestExecutionResult.Status status = testExecutionResult.getStatus();
        if (status == TestExecutionResult.Status.ABORTED) {
            this.notifier.fireTestAssumptionFailed(this.toFailure(testExecutionResult, description));
        } else if (status == TestExecutionResult.Status.FAILED) {
            this.notifier.fireTestFailure(this.toFailure(testExecutionResult, description));
        }
        if (testIdentifier.isTest()) {
            this.notifier.fireTestFinished(description);
        }
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        entry.appendDescription((Appendable)System.out, "");
    }

    private Failure toFailure(TestExecutionResult testExecutionResult, Description description) {
        return new Failure(description, (Throwable)testExecutionResult.getThrowable().orElse(null));
    }

    private Description findJUnit4Description(TestIdentifier testIdentifier) {
        return this.testTree.getDescription(testIdentifier);
    }
}

