/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.junit4.runner;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.Preconditions;
import org.junit.gen5.commons.util.StringUtils;
import org.junit.gen5.engine.DiscoveryFilter;
import org.junit.gen5.engine.DiscoverySelector;
import org.junit.gen5.engine.discovery.ClassFilter;
import org.junit.gen5.engine.discovery.ClassSelector;
import org.junit.gen5.engine.discovery.PackageSelector;
import org.junit.gen5.engine.discovery.UniqueIdSelector;
import org.junit.gen5.junit4.runner.Classes;
import org.junit.gen5.junit4.runner.ExcludeTags;
import org.junit.gen5.junit4.runner.FilterClassName;
import org.junit.gen5.junit4.runner.JUnit5RunnerListener;
import org.junit.gen5.junit4.runner.JUnit5TestTree;
import org.junit.gen5.junit4.runner.Packages;
import org.junit.gen5.junit4.runner.RequireEngine;
import org.junit.gen5.junit4.runner.RequireTags;
import org.junit.gen5.junit4.runner.UniqueIds;
import org.junit.gen5.launcher.EngineIdFilter;
import org.junit.gen5.launcher.Launcher;
import org.junit.gen5.launcher.PostDiscoveryFilter;
import org.junit.gen5.launcher.TagFilter;
import org.junit.gen5.launcher.TestDiscoveryRequest;
import org.junit.gen5.launcher.TestExecutionListener;
import org.junit.gen5.launcher.TestIdentifier;
import org.junit.gen5.launcher.TestPlan;
import org.junit.gen5.launcher.main.LauncherFactory;
import org.junit.gen5.launcher.main.TestDiscoveryRequestBuilder;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

@API(value=API.Usage.Maintained)
public class JUnit5
extends Runner
implements Filterable {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String EMPTY_STRING = "";
    private final Class<?> testClass;
    private final Launcher launcher;
    private TestDiscoveryRequest discoveryRequest;
    private JUnit5TestTree testTree;

    public JUnit5(Class<?> testClass) throws InitializationError {
        this(testClass, LauncherFactory.create());
    }

    JUnit5(Class<?> testClass, Launcher launcher) throws InitializationError {
        this.launcher = launcher;
        this.testClass = testClass;
        this.discoveryRequest = this.createDiscoveryRequest();
        this.testTree = this.generateTestTree();
    }

    public Description getDescription() {
        return this.testTree.getSuiteDescription();
    }

    public void run(RunNotifier notifier) {
        JUnit5RunnerListener listener = new JUnit5RunnerListener(this.testTree, notifier);
        this.launcher.registerTestExecutionListeners(new TestExecutionListener[]{listener});
        this.launcher.execute(this.discoveryRequest);
    }

    private JUnit5TestTree generateTestTree() {
        Preconditions.notNull((Object)this.discoveryRequest, (String)"DiscoveryRequest must not be null");
        TestPlan plan = this.launcher.discover(this.discoveryRequest);
        return new JUnit5TestTree(plan, this.testClass);
    }

    private TestDiscoveryRequest createDiscoveryRequest() {
        List<DiscoverySelector> selectors = this.getSpecElementsFromAnnotations();
        if (selectors.isEmpty()) {
            selectors.add((DiscoverySelector)ClassSelector.forClass(this.testClass));
        }
        TestDiscoveryRequest request = TestDiscoveryRequestBuilder.request().select(selectors).build();
        this.addFiltersFromAnnotations(request);
        return request;
    }

    private void addFiltersFromAnnotations(TestDiscoveryRequest request) {
        this.addClassNameMatchesFilter(request);
        this.addRequiredTagsFilter(request);
        this.addExcludedTagsFilter(request);
        this.addEngineIdFilter(request);
    }

    private List<DiscoverySelector> getSpecElementsFromAnnotations() {
        ArrayList<DiscoverySelector> selectors = new ArrayList<DiscoverySelector>();
        selectors.addAll(this.transform(this.getTestClasses(), ClassSelector::forClass));
        selectors.addAll(this.transform(this.getUniqueIds(), UniqueIdSelector::forUniqueId));
        selectors.addAll(this.transform(this.getPackageNames(), PackageSelector::forPackageName));
        return selectors;
    }

    private <T> List<DiscoverySelector> transform(T[] sourceElements, Function<T, DiscoverySelector> transformer) {
        return Arrays.stream(sourceElements).map(transformer).collect(Collectors.toList());
    }

    private void addClassNameMatchesFilter(TestDiscoveryRequest discoveryRequest) {
        String regex = this.getClassNameRegExPattern();
        if (!regex.isEmpty()) {
            discoveryRequest.addFilter((DiscoveryFilter)ClassFilter.byNamePattern((String)regex));
        }
    }

    private void addRequiredTagsFilter(TestDiscoveryRequest discoveryRequest) {
        String[] requiredTags = this.getRequiredTags();
        if (requiredTags.length > 0) {
            PostDiscoveryFilter tagNamesFilter = TagFilter.requireTags((String[])requiredTags);
            discoveryRequest.addPostFilter(tagNamesFilter);
        }
    }

    private void addExcludedTagsFilter(TestDiscoveryRequest discoveryRequest) {
        String[] excludedTags = this.getExcludedTags();
        if (excludedTags.length > 0) {
            PostDiscoveryFilter excludeTagsFilter = TagFilter.excludeTags((String[])excludedTags);
            discoveryRequest.addPostFilter(excludeTagsFilter);
        }
    }

    private void addEngineIdFilter(TestDiscoveryRequest discoveryRequest) {
        String engineId = this.getExplicitEngineId();
        if (StringUtils.isNotBlank((String)engineId)) {
            EngineIdFilter engineFilter = EngineIdFilter.byEngineId((String)engineId);
            discoveryRequest.addEngineIdFilter(engineFilter);
        }
    }

    private Class<?>[] getTestClasses() {
        return this.getValueFromAnnotation(Classes.class, Classes::value, EMPTY_CLASS_ARRAY);
    }

    private String[] getUniqueIds() {
        return this.getValueFromAnnotation(UniqueIds.class, UniqueIds::value, EMPTY_STRING_ARRAY);
    }

    private String[] getPackageNames() {
        return this.getValueFromAnnotation(Packages.class, Packages::value, EMPTY_STRING_ARRAY);
    }

    private String[] getRequiredTags() {
        return this.getValueFromAnnotation(RequireTags.class, RequireTags::value, EMPTY_STRING_ARRAY);
    }

    private String[] getExcludedTags() {
        return this.getValueFromAnnotation(ExcludeTags.class, ExcludeTags::value, EMPTY_STRING_ARRAY);
    }

    private String getExplicitEngineId() {
        return this.getValueFromAnnotation(RequireEngine.class, RequireEngine::value, EMPTY_STRING).trim();
    }

    private String getClassNameRegExPattern() {
        return this.getValueFromAnnotation(FilterClassName.class, FilterClassName::value, EMPTY_STRING).trim();
    }

    private <A extends Annotation, V> V getValueFromAnnotation(Class<A> annotationClass, Function<A, V> extractor, V defaultValue) {
        A annotation = this.testClass.getAnnotation(annotationClass);
        return annotation != null ? extractor.apply(annotation) : defaultValue;
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        Set<TestIdentifier> filteredIdentifiers = this.testTree.getFilteredLeaves(filter);
        if (filteredIdentifiers.isEmpty()) {
            throw new NoTestsRemainException();
        }
        this.discoveryRequest = this.createDiscoveryRequestForUniqueIds(filteredIdentifiers);
        this.testTree = this.generateTestTree();
    }

    private TestDiscoveryRequest createDiscoveryRequestForUniqueIds(Set<TestIdentifier> testIdentifiers) {
        List selectors = testIdentifiers.stream().map(TestIdentifier::getUniqueId).map(Object::toString).map(UniqueIdSelector::forUniqueId).collect(Collectors.toList());
        return TestDiscoveryRequestBuilder.request().select(selectors).build();
    }
}

