/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.launcher.main;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.gen5.engine.FilterResult;
import org.junit.gen5.engine.TestDescriptor;
import org.junit.gen5.engine.TestEngine;
import org.junit.gen5.launcher.TestDiscoveryRequest;

class Root {
    private final Map<TestEngine, TestDescriptor> testEngineDescriptors = new LinkedHashMap<TestEngine, TestDescriptor>();

    Root() {
    }

    void add(TestEngine engine, TestDescriptor testDescriptor) {
        this.testEngineDescriptors.put(engine, testDescriptor);
    }

    Iterable<TestEngine> getTestEngines() {
        return this.testEngineDescriptors.keySet();
    }

    Collection<TestDescriptor> getEngineDescriptors() {
        return this.testEngineDescriptors.values();
    }

    TestDescriptor getTestDescriptorFor(TestEngine testEngine) {
        return this.testEngineDescriptors.get(testEngine);
    }

    void applyPostDiscoveryFilters(TestDiscoveryRequest discoveryRequest) {
        TestDescriptor.Visitor filteringVisitor = (descriptor, remove) -> {
            if (!descriptor.isTest()) {
                return;
            }
            if (this.isExcluded(discoveryRequest, descriptor)) {
                remove.run();
            }
        };
        this.acceptInAllTestEngines(filteringVisitor);
    }

    void prune() {
        TestDescriptor.Visitor pruningVisitor = (descriptor, remove) -> {
            if (descriptor.isRoot() || descriptor.hasTests()) {
                return;
            }
            remove.run();
        };
        this.acceptInAllTestEngines(pruningVisitor);
        this.pruneEmptyTestEngines();
    }

    private boolean isExcluded(TestDiscoveryRequest discoveryRequest, TestDescriptor descriptor) {
        return discoveryRequest.getPostDiscoveryFilters().stream().map(filter -> filter.filter(descriptor)).anyMatch(FilterResult::excluded);
    }

    private void acceptInAllTestEngines(TestDescriptor.Visitor visitor) {
        this.testEngineDescriptors.values().stream().forEach(testEngine -> testEngine.accept(visitor));
    }

    private void pruneEmptyTestEngines() {
        this.testEngineDescriptors.values().removeIf(testEngine -> testEngine.getChildren().isEmpty());
    }
}

