/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.launcher.main;

import org.junit.gen5.engine.EngineExecutionListener;
import org.junit.gen5.engine.TestDescriptor;
import org.junit.gen5.engine.TestExecutionResult;
import org.junit.gen5.engine.reporting.ReportEntry;
import org.junit.gen5.launcher.TestExecutionListener;
import org.junit.gen5.launcher.TestId;
import org.junit.gen5.launcher.TestIdentifier;
import org.junit.gen5.launcher.TestPlan;

class ExecutionListenerAdapter
implements EngineExecutionListener {
    private final TestPlan testPlan;
    private final TestExecutionListener testExecutionListener;

    public ExecutionListenerAdapter(TestPlan testPlan, TestExecutionListener testExecutionListener) {
        this.testPlan = testPlan;
        this.testExecutionListener = testExecutionListener;
    }

    public void dynamicTestRegistered(TestDescriptor testDescriptor) {
        TestIdentifier testIdentifier = TestIdentifier.from(testDescriptor);
        this.testPlan.add(testIdentifier);
        this.testExecutionListener.dynamicTestRegistered(testIdentifier);
    }

    public void executionStarted(TestDescriptor testDescriptor) {
        this.testExecutionListener.executionStarted(this.getTestIdentifier(testDescriptor));
    }

    public void executionSkipped(TestDescriptor testDescriptor, String reason) {
        this.testExecutionListener.executionSkipped(this.getTestIdentifier(testDescriptor), reason);
    }

    public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
        this.testExecutionListener.executionFinished(this.getTestIdentifier(testDescriptor), testExecutionResult);
    }

    public void reportingEntryPublished(TestDescriptor testDescriptor, ReportEntry entry) {
        this.testExecutionListener.reportingEntryPublished(this.getTestIdentifier(testDescriptor), entry);
    }

    private TestIdentifier getTestIdentifier(TestDescriptor testDescriptor) {
        return this.testPlan.getTestIdentifier(new TestId(testDescriptor.getUniqueId()));
    }
}

