/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.launcher;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.PreconditionViolationException;
import org.junit.gen5.commons.util.Preconditions;
import org.junit.gen5.engine.TestDescriptor;
import org.junit.gen5.launcher.TestId;
import org.junit.gen5.launcher.TestIdentifier;

@API(value=API.Usage.Experimental)
public final class TestPlan {
    private final Set<TestIdentifier> roots = new LinkedHashSet<TestIdentifier>();
    private final Map<TestId, LinkedHashSet<TestIdentifier>> children = new LinkedHashMap<TestId, LinkedHashSet<TestIdentifier>>();
    private final Map<TestId, TestIdentifier> allIdentifiers = new LinkedHashMap<TestId, TestIdentifier>();

    public static TestPlan from(Collection<TestDescriptor> engineDescriptors) {
        TestPlan testPlan = new TestPlan();
        TestDescriptor.Visitor visitor = (descriptor, remove) -> testPlan.add(TestIdentifier.from(descriptor));
        engineDescriptors.stream().forEach(engineDescriptor -> engineDescriptor.accept(visitor));
        return testPlan;
    }

    private TestPlan() {
    }

    public void add(TestIdentifier testIdentifier) {
        this.allIdentifiers.put(testIdentifier.getUniqueId(), testIdentifier);
        if (testIdentifier.getParentId().isPresent()) {
            TestId parentId = testIdentifier.getParentId().get();
            Set directChildren = this.children.computeIfAbsent(parentId, key -> new LinkedHashSet());
            directChildren.add(testIdentifier);
        } else {
            this.roots.add(testIdentifier);
        }
    }

    public Set<TestIdentifier> getRoots() {
        return Collections.unmodifiableSet(this.roots);
    }

    public Optional<TestIdentifier> getParent(TestIdentifier child) {
        Optional<TestId> optionalParentId = child.getParentId();
        if (optionalParentId.isPresent()) {
            return Optional.of(this.getTestIdentifier(optionalParentId.get()));
        }
        return Optional.empty();
    }

    public Set<TestIdentifier> getChildren(TestIdentifier parent) {
        return this.getChildren(parent.getUniqueId());
    }

    public Set<TestIdentifier> getChildren(TestId parentId) {
        return this.children.containsKey(parentId) ? Collections.unmodifiableSet((Set)this.children.get(parentId)) : Collections.emptySet();
    }

    public TestIdentifier getTestIdentifier(TestId testId) throws PreconditionViolationException {
        Preconditions.condition((boolean)this.allIdentifiers.containsKey(testId), () -> "No TestIdentifier with this TestId has been added to this TestPlan: " + testId);
        return this.allIdentifiers.get(testId);
    }

    public long countTestIdentifiers(Predicate<? super TestIdentifier> predicate) {
        return this.allIdentifiers.values().stream().filter(predicate).count();
    }

    public Set<TestIdentifier> getDescendants(TestIdentifier parent) {
        LinkedHashSet<TestIdentifier> result = new LinkedHashSet<TestIdentifier>();
        Set<TestIdentifier> children = this.getChildren(parent);
        result.addAll(children);
        for (TestIdentifier child : children) {
            result.addAll(this.getDescendants(child));
        }
        return Collections.unmodifiableSet(result);
    }
}

