/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.launcher;

import java.util.Arrays;
import java.util.List;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.engine.FilterResult;
import org.junit.gen5.engine.TestTag;
import org.junit.gen5.launcher.PostDiscoveryFilter;

@API(value=API.Usage.Experimental)
public final class TagFilter {
    private TagFilter() {
    }

    public static PostDiscoveryFilter requireTags(String ... tags) {
        return TagFilter.requireTags(Arrays.asList(tags));
    }

    public static PostDiscoveryFilter requireTags(List<String> tags) {
        return descriptor -> FilterResult.includedIf((boolean)descriptor.getTags().stream().map(TestTag::getName).map(String::trim).anyMatch(tags::contains));
    }

    public static PostDiscoveryFilter excludeTags(String ... tags) {
        return TagFilter.excludeTags(Arrays.asList(tags));
    }

    public static PostDiscoveryFilter excludeTags(List<String> tags) {
        return descriptor -> FilterResult.includedIf((boolean)descriptor.getTags().stream().map(TestTag::getName).map(String::trim).noneMatch(tags::contains));
    }
}

