/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadUtil {
    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException iex) {
            Thread.currentThread().interrupt();
        }
    }

    public static void sleep() {
        try {
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (InterruptedException iex) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wait(Object obj) {
        Object object = obj;
        synchronized (object) {
            try {
                obj.wait();
            }
            catch (InterruptedException inex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wait(Object obj, long timeout) {
        Object object = obj;
        synchronized (object) {
            try {
                obj.wait(timeout);
            }
            catch (InterruptedException inex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notify(Object obj) {
        Object object = obj;
        synchronized (object) {
            obj.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyAll(Object obj) {
        Object object = obj;
        synchronized (object) {
            obj.notifyAll();
        }
    }

    public static void join(Thread thread) {
        try {
            thread.join();
        }
        catch (InterruptedException inex) {
            Thread.currentThread().interrupt();
        }
    }

    public static void join(Thread thread, long millis) {
        try {
            thread.join(millis);
        }
        catch (InterruptedException inex) {
            Thread.currentThread().interrupt();
        }
    }

    public static void join(Thread thread, long millis, int nanos) {
        try {
            thread.join(millis, nanos);
        }
        catch (InterruptedException inex) {
            Thread.currentThread().interrupt();
        }
    }

    public static ThreadFactory daemonThreadFactory(String name) {
        return ThreadUtil.daemonThreadFactory(name, 5);
    }

    public static ThreadFactory daemonThreadFactory(final String name, final int priority) {
        return new ThreadFactory(){
            private AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName(name + '-' + this.count.incrementAndGet());
                thread.setDaemon(true);
                thread.setPriority(priority);
                return thread;
            }
        };
    }

    public static ExecutorService newCoreThreadPool(String name) {
        int cpus = Runtime.getRuntime().availableProcessors();
        return ThreadUtil.newCoreThreadPool(name, 5 * cpus, 15 * cpus, 60);
    }

    public static ExecutorService newCoreThreadPool(String name, int coreSize, int maxSize, int idleTimeoutInSeconds) {
        return ThreadUtil.newCoreThreadPool(ThreadUtil.daemonThreadFactory(name), coreSize, maxSize, idleTimeoutInSeconds);
    }

    public static ExecutorService newCoreThreadPool(ThreadFactory threadFactory, int coreSize, int maxSize, int idleTimeoutInSeconds) {
        return new ThreadPoolExecutor(coreSize, maxSize, idleTimeoutInSeconds, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
    }
}

