/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.transaction.annotation;

import org.evosuite.shaded.org.springframework.context.annotation.Bean;
import org.evosuite.shaded.org.springframework.context.annotation.Configuration;
import org.evosuite.shaded.org.springframework.context.annotation.Role;
import org.evosuite.shaded.org.springframework.transaction.annotation.AbstractTransactionManagementConfiguration;
import org.evosuite.shaded.org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.evosuite.shaded.org.springframework.transaction.interceptor.BeanFactoryTransactionAttributeSourceAdvisor;
import org.evosuite.shaded.org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.evosuite.shaded.org.springframework.transaction.interceptor.TransactionInterceptor;

@Configuration
public class ProxyTransactionManagementConfiguration
extends AbstractTransactionManagementConfiguration {
    @Bean(name={"org.evosuite.shaded.org.springframework.transaction.config.internalTransactionAdvisor"})
    @Role(value=2)
    public BeanFactoryTransactionAttributeSourceAdvisor transactionAdvisor() {
        BeanFactoryTransactionAttributeSourceAdvisor advisor = new BeanFactoryTransactionAttributeSourceAdvisor();
        advisor.setTransactionAttributeSource(this.transactionAttributeSource());
        advisor.setAdvice(this.transactionInterceptor());
        advisor.setOrder((Integer)this.enableTx.getNumber("order"));
        return advisor;
    }

    @Bean
    @Role(value=2)
    public TransactionAttributeSource transactionAttributeSource() {
        return new AnnotationTransactionAttributeSource();
    }

    @Bean
    @Role(value=2)
    public TransactionInterceptor transactionInterceptor() {
        TransactionInterceptor interceptor = new TransactionInterceptor();
        interceptor.setTransactionAttributeSource(this.transactionAttributeSource());
        if (this.txManager != null) {
            interceptor.setTransactionManager(this.txManager);
        }
        return interceptor;
    }
}

