/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.orm.jpa.support;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.evosuite.shaded.org.springframework.dao.DataAccessException;
import org.evosuite.shaded.org.springframework.dao.DataAccessResourceFailureException;
import org.evosuite.shaded.org.springframework.orm.jpa.EntityManagerFactoryAccessor;
import org.evosuite.shaded.org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.evosuite.shaded.org.springframework.orm.jpa.EntityManagerHolder;
import org.evosuite.shaded.org.springframework.orm.jpa.support.AsyncRequestInterceptor;
import org.evosuite.shaded.org.springframework.transaction.support.TransactionSynchronizationManager;
import org.evosuite.shaded.org.springframework.ui.ModelMap;
import org.evosuite.shaded.org.springframework.web.context.request.AsyncWebRequestInterceptor;
import org.evosuite.shaded.org.springframework.web.context.request.WebRequest;
import org.evosuite.shaded.org.springframework.web.context.request.async.CallableProcessingInterceptor;
import org.evosuite.shaded.org.springframework.web.context.request.async.DeferredResultProcessingInterceptor;
import org.evosuite.shaded.org.springframework.web.context.request.async.WebAsyncManager;
import org.evosuite.shaded.org.springframework.web.context.request.async.WebAsyncUtils;

public class OpenEntityManagerInViewInterceptor
extends EntityManagerFactoryAccessor
implements AsyncWebRequestInterceptor {
    public static final String PARTICIPATE_SUFFIX = ".PARTICIPATE";

    public void preHandle(WebRequest request) throws DataAccessException {
        String participateAttributeName = this.getParticipateAttributeName();
        WebAsyncManager asyncManager = WebAsyncUtils.getAsyncManager((WebRequest)request);
        if (asyncManager.hasConcurrentResult() && this.applyCallableInterceptor(asyncManager, participateAttributeName)) {
            return;
        }
        if (TransactionSynchronizationManager.hasResource(this.getEntityManagerFactory())) {
            Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
            int newCount = count != null ? count + 1 : 1;
            request.setAttribute(this.getParticipateAttributeName(), (Object)newCount, 0);
        } else {
            this.logger.debug("Opening JPA EntityManager in OpenEntityManagerInViewInterceptor");
            try {
                EntityManager em = this.createEntityManager();
                EntityManagerHolder emHolder = new EntityManagerHolder(em);
                TransactionSynchronizationManager.bindResource(this.getEntityManagerFactory(), emHolder);
                AsyncRequestInterceptor interceptor = new AsyncRequestInterceptor(this.getEntityManagerFactory(), emHolder);
                asyncManager.registerCallableInterceptor((Object)participateAttributeName, (CallableProcessingInterceptor)interceptor);
                asyncManager.registerDeferredResultInterceptor((Object)participateAttributeName, (DeferredResultProcessingInterceptor)interceptor);
            }
            catch (PersistenceException ex) {
                throw new DataAccessResourceFailureException("Could not create JPA EntityManager", ex);
            }
        }
    }

    public void postHandle(WebRequest request, ModelMap model) {
    }

    public void afterCompletion(WebRequest request, Exception ex) throws DataAccessException {
        if (!this.decrementParticipateCount(request)) {
            EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.unbindResource(this.getEntityManagerFactory());
            this.logger.debug("Closing JPA EntityManager in OpenEntityManagerInViewInterceptor");
            EntityManagerFactoryUtils.closeEntityManager(emHolder.getEntityManager());
        }
    }

    private boolean decrementParticipateCount(WebRequest request) {
        String participateAttributeName = this.getParticipateAttributeName();
        Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
        if (count == null) {
            return false;
        }
        if (count > 1) {
            request.setAttribute(participateAttributeName, (Object)(count - 1), 0);
        } else {
            request.removeAttribute(participateAttributeName, 0);
        }
        return true;
    }

    public void afterConcurrentHandlingStarted(WebRequest request) {
        if (!this.decrementParticipateCount(request)) {
            TransactionSynchronizationManager.unbindResource(this.getEntityManagerFactory());
        }
    }

    protected String getParticipateAttributeName() {
        return this.getEntityManagerFactory().toString() + PARTICIPATE_SUFFIX;
    }

    private boolean applyCallableInterceptor(WebAsyncManager asyncManager, String key) {
        if (asyncManager.getCallableInterceptor((Object)key) == null) {
            return false;
        }
        ((AsyncRequestInterceptor)asyncManager.getCallableInterceptor((Object)key)).bindSession();
        return true;
    }
}

