/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.orm.hibernate5;

import java.lang.reflect.Method;
import java.util.Map;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.evosuite.shaded.org.apache.commons.logging.Log;
import org.evosuite.shaded.org.apache.commons.logging.LogFactory;
import org.evosuite.shaded.org.hibernate.FlushMode;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.JDBCException;
import org.evosuite.shaded.org.hibernate.NonUniqueObjectException;
import org.evosuite.shaded.org.hibernate.NonUniqueResultException;
import org.evosuite.shaded.org.hibernate.ObjectDeletedException;
import org.evosuite.shaded.org.hibernate.PersistentObjectException;
import org.evosuite.shaded.org.hibernate.PessimisticLockException;
import org.evosuite.shaded.org.hibernate.PropertyValueException;
import org.evosuite.shaded.org.hibernate.QueryException;
import org.evosuite.shaded.org.hibernate.QueryTimeoutException;
import org.evosuite.shaded.org.hibernate.Session;
import org.evosuite.shaded.org.hibernate.SessionFactory;
import org.evosuite.shaded.org.hibernate.StaleObjectStateException;
import org.evosuite.shaded.org.hibernate.StaleStateException;
import org.evosuite.shaded.org.hibernate.TransientObjectException;
import org.evosuite.shaded.org.hibernate.UnresolvableObjectException;
import org.evosuite.shaded.org.hibernate.WrongClassException;
import org.evosuite.shaded.org.hibernate.dialect.lock.OptimisticEntityLockException;
import org.evosuite.shaded.org.hibernate.dialect.lock.PessimisticEntityLockException;
import org.evosuite.shaded.org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.exception.ConstraintViolationException;
import org.evosuite.shaded.org.hibernate.exception.DataException;
import org.evosuite.shaded.org.hibernate.exception.JDBCConnectionException;
import org.evosuite.shaded.org.hibernate.exception.LockAcquisitionException;
import org.evosuite.shaded.org.hibernate.exception.SQLGrammarException;
import org.evosuite.shaded.org.hibernate.service.UnknownServiceException;
import org.evosuite.shaded.org.springframework.dao.CannotAcquireLockException;
import org.evosuite.shaded.org.springframework.dao.DataAccessException;
import org.evosuite.shaded.org.springframework.dao.DataAccessResourceFailureException;
import org.evosuite.shaded.org.springframework.dao.DataIntegrityViolationException;
import org.evosuite.shaded.org.springframework.dao.DuplicateKeyException;
import org.evosuite.shaded.org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.evosuite.shaded.org.springframework.dao.InvalidDataAccessApiUsageException;
import org.evosuite.shaded.org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.evosuite.shaded.org.springframework.dao.PessimisticLockingFailureException;
import org.evosuite.shaded.org.springframework.orm.hibernate5.HibernateJdbcException;
import org.evosuite.shaded.org.springframework.orm.hibernate5.HibernateObjectRetrievalFailureException;
import org.evosuite.shaded.org.springframework.orm.hibernate5.HibernateOptimisticLockingFailureException;
import org.evosuite.shaded.org.springframework.orm.hibernate5.HibernateQueryException;
import org.evosuite.shaded.org.springframework.orm.hibernate5.HibernateSystemException;
import org.evosuite.shaded.org.springframework.util.Assert;
import org.evosuite.shaded.org.springframework.util.ClassUtils;
import org.evosuite.shaded.org.springframework.util.ReflectionUtils;

public abstract class SessionFactoryUtils {
    public static final int SESSION_SYNCHRONIZATION_ORDER = 900;
    static final Log logger = LogFactory.getLog(SessionFactoryUtils.class);
    private static Method getFlushMode;

    static FlushMode getFlushMode(Session session) {
        return (FlushMode)((Object)ReflectionUtils.invokeMethod(getFlushMode, session));
    }

    static void flush(Session session, boolean synch) throws DataAccessException {
        if (synch) {
            logger.debug("Flushing Hibernate Session on transaction synchronization");
        } else {
            logger.debug("Flushing Hibernate Session on explicit request");
        }
        try {
            session.flush();
        }
        catch (HibernateException ex) {
            throw SessionFactoryUtils.convertHibernateAccessException(ex);
        }
        catch (PersistenceException ex) {
            if (ex.getCause() instanceof HibernateException) {
                throw SessionFactoryUtils.convertHibernateAccessException((HibernateException)ex.getCause());
            }
            throw ex;
        }
    }

    public static void closeSession(Session session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (HibernateException ex) {
                logger.debug("Could not close Hibernate Session", ex);
            }
            catch (Throwable ex) {
                logger.debug("Unexpected exception on closing Hibernate Session", ex);
            }
        }
    }

    public static DataSource getDataSource(SessionFactory sessionFactory) {
        block5: {
            Map props;
            Object dataSourceValue;
            Method getProperties = ClassUtils.getMethodIfAvailable(sessionFactory.getClass(), "getProperties", new Class[0]);
            if (getProperties != null && (dataSourceValue = (props = (Map)ReflectionUtils.invokeMethod(getProperties, sessionFactory)).get("hibernate.connection.datasource")) instanceof DataSource) {
                return (DataSource)dataSourceValue;
            }
            if (sessionFactory instanceof SessionFactoryImplementor) {
                SessionFactoryImplementor sfi = (SessionFactoryImplementor)sessionFactory;
                try {
                    ConnectionProvider cp = sfi.getServiceRegistry().getService(ConnectionProvider.class);
                    if (cp != null) {
                        return cp.unwrap(DataSource.class);
                    }
                }
                catch (UnknownServiceException ex) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug("No ConnectionProvider found - cannot determine DataSource for SessionFactory: " + ex);
                }
            }
        }
        return null;
    }

    public static DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (ex instanceof JDBCConnectionException) {
            return new DataAccessResourceFailureException(ex.getMessage(), ex);
        }
        if (ex instanceof SQLGrammarException) {
            SQLGrammarException jdbcEx = (SQLGrammarException)ex;
            return new InvalidDataAccessResourceUsageException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", ex);
        }
        if (ex instanceof QueryTimeoutException) {
            QueryTimeoutException jdbcEx = (QueryTimeoutException)ex;
            return new org.evosuite.shaded.org.springframework.dao.QueryTimeoutException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", ex);
        }
        if (ex instanceof LockAcquisitionException) {
            LockAcquisitionException jdbcEx = (LockAcquisitionException)ex;
            return new CannotAcquireLockException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", ex);
        }
        if (ex instanceof PessimisticLockException) {
            PessimisticLockException jdbcEx = (PessimisticLockException)ex;
            return new PessimisticLockingFailureException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", ex);
        }
        if (ex instanceof ConstraintViolationException) {
            ConstraintViolationException jdbcEx = (ConstraintViolationException)ex;
            return new DataIntegrityViolationException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]; constraint [" + jdbcEx.getConstraintName() + "]", ex);
        }
        if (ex instanceof DataException) {
            DataException jdbcEx = (DataException)ex;
            return new DataIntegrityViolationException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", ex);
        }
        if (ex instanceof JDBCException) {
            return new HibernateJdbcException((JDBCException)ex);
        }
        if (ex instanceof QueryException) {
            return new HibernateQueryException((QueryException)ex);
        }
        if (ex instanceof NonUniqueResultException) {
            return new IncorrectResultSizeDataAccessException(ex.getMessage(), 1, ex);
        }
        if (ex instanceof NonUniqueObjectException) {
            return new DuplicateKeyException(ex.getMessage(), ex);
        }
        if (ex instanceof PropertyValueException) {
            return new DataIntegrityViolationException(ex.getMessage(), ex);
        }
        if (ex instanceof PersistentObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), ex);
        }
        if (ex instanceof TransientObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), ex);
        }
        if (ex instanceof ObjectDeletedException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), ex);
        }
        if (ex instanceof UnresolvableObjectException) {
            return new HibernateObjectRetrievalFailureException((UnresolvableObjectException)ex);
        }
        if (ex instanceof WrongClassException) {
            return new HibernateObjectRetrievalFailureException((WrongClassException)ex);
        }
        if (ex instanceof StaleObjectStateException) {
            return new HibernateOptimisticLockingFailureException((StaleObjectStateException)ex);
        }
        if (ex instanceof StaleStateException) {
            return new HibernateOptimisticLockingFailureException((StaleStateException)ex);
        }
        if (ex instanceof OptimisticEntityLockException) {
            return new HibernateOptimisticLockingFailureException((OptimisticEntityLockException)ex);
        }
        if (ex instanceof PessimisticEntityLockException) {
            if (ex.getCause() instanceof LockAcquisitionException) {
                return new CannotAcquireLockException(ex.getMessage(), ex.getCause());
            }
            return new PessimisticLockingFailureException(ex.getMessage(), ex);
        }
        return new HibernateSystemException(ex);
    }

    static {
        try {
            getFlushMode = Session.class.getMethod("getHibernateFlushMode", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            try {
                getFlushMode = Session.class.getMethod("getFlushMode", new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                throw new IllegalStateException("No compatible Hibernate getFlushMode signature found", ex2);
            }
        }
        Assert.state(FlushMode.class == getFlushMode.getReturnType(), "Could not find Hibernate getFlushMode method");
    }
}

