/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.orm.hibernate3.support;

import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.Session;
import org.evosuite.shaded.org.springframework.dao.DataAccessException;
import org.evosuite.shaded.org.springframework.orm.hibernate3.HibernateAccessor;
import org.evosuite.shaded.org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.evosuite.shaded.org.springframework.orm.hibernate3.SessionHolder;
import org.evosuite.shaded.org.springframework.orm.hibernate3.support.AsyncRequestInterceptor;
import org.evosuite.shaded.org.springframework.transaction.support.TransactionSynchronizationManager;
import org.evosuite.shaded.org.springframework.ui.ModelMap;
import org.evosuite.shaded.org.springframework.web.context.request.AsyncWebRequestInterceptor;
import org.evosuite.shaded.org.springframework.web.context.request.WebRequest;
import org.evosuite.shaded.org.springframework.web.context.request.async.CallableProcessingInterceptor;
import org.evosuite.shaded.org.springframework.web.context.request.async.DeferredResultProcessingInterceptor;
import org.evosuite.shaded.org.springframework.web.context.request.async.WebAsyncManager;
import org.evosuite.shaded.org.springframework.web.context.request.async.WebAsyncUtils;

@Deprecated
public class OpenSessionInViewInterceptor
extends HibernateAccessor
implements AsyncWebRequestInterceptor {
    public static final String PARTICIPATE_SUFFIX = ".PARTICIPATE";
    private boolean singleSession = true;

    public OpenSessionInViewInterceptor() {
        this.setFlushMode(0);
    }

    public void setSingleSession(boolean singleSession) {
        this.singleSession = singleSession;
    }

    protected boolean isSingleSession() {
        return this.singleSession;
    }

    public void preHandle(WebRequest request) throws DataAccessException {
        String participateAttributeName = this.getParticipateAttributeName();
        WebAsyncManager asyncManager = WebAsyncUtils.getAsyncManager((WebRequest)request);
        if (asyncManager.hasConcurrentResult() && this.applySessionBindingInterceptor(asyncManager, participateAttributeName)) {
            return;
        }
        if (this.isSingleSession() && TransactionSynchronizationManager.hasResource(this.getSessionFactory()) || SessionFactoryUtils.isDeferredCloseActive(this.getSessionFactory())) {
            Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
            int newCount = count != null ? count + 1 : 1;
            request.setAttribute(this.getParticipateAttributeName(), (Object)newCount, 0);
        } else if (this.isSingleSession()) {
            this.logger.debug("Opening single Hibernate Session in OpenSessionInViewInterceptor");
            Session session = SessionFactoryUtils.getSession(this.getSessionFactory(), this.getEntityInterceptor(), this.getJdbcExceptionTranslator());
            this.applyFlushMode(session, false);
            SessionHolder sessionHolder = new SessionHolder(session);
            TransactionSynchronizationManager.bindResource(this.getSessionFactory(), sessionHolder);
            AsyncRequestInterceptor asyncRequestInterceptor = new AsyncRequestInterceptor(this.getSessionFactory(), sessionHolder);
            asyncManager.registerCallableInterceptor((Object)participateAttributeName, (CallableProcessingInterceptor)asyncRequestInterceptor);
            asyncManager.registerDeferredResultInterceptor((Object)participateAttributeName, (DeferredResultProcessingInterceptor)asyncRequestInterceptor);
        } else {
            SessionFactoryUtils.initDeferredClose(this.getSessionFactory());
        }
    }

    public void postHandle(WebRequest request, ModelMap model) throws DataAccessException {
        if (this.isSingleSession()) {
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(this.getSessionFactory());
            this.logger.debug("Flushing single Hibernate Session in OpenSessionInViewInterceptor");
            try {
                this.flushIfNecessary(sessionHolder.getSession(), false);
            }
            catch (HibernateException ex) {
                throw this.convertHibernateAccessException(ex);
            }
        }
    }

    public void afterCompletion(WebRequest request, Exception ex) throws DataAccessException {
        if (!this.decrementParticipateCount(request)) {
            if (this.isSingleSession()) {
                SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
                this.logger.debug("Closing single Hibernate Session in OpenSessionInViewInterceptor");
                SessionFactoryUtils.closeSession(sessionHolder.getSession());
            } else {
                SessionFactoryUtils.processDeferredClose(this.getSessionFactory());
            }
        }
    }

    public void afterConcurrentHandlingStarted(WebRequest request) {
        if (!this.decrementParticipateCount(request)) {
            if (this.isSingleSession()) {
                TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
            } else {
                throw new IllegalStateException("Deferred close mode is not supported with async requests.");
            }
        }
    }

    private boolean decrementParticipateCount(WebRequest request) {
        String participateAttributeName = this.getParticipateAttributeName();
        Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
        if (count == null) {
            return false;
        }
        if (count > 1) {
            request.setAttribute(participateAttributeName, (Object)(count - 1), 0);
        } else {
            request.removeAttribute(participateAttributeName, 0);
        }
        return true;
    }

    protected String getParticipateAttributeName() {
        return this.getSessionFactory().toString() + PARTICIPATE_SUFFIX;
    }

    private boolean applySessionBindingInterceptor(WebAsyncManager asyncManager, String key) {
        if (asyncManager.getCallableInterceptor((Object)key) == null) {
            return false;
        }
        ((AsyncRequestInterceptor)asyncManager.getCallableInterceptor((Object)key)).bindSession();
        return true;
    }
}

