/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.support.nativejdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.evosuite.shaded.org.springframework.jdbc.datasource.DataSourceUtils;
import org.evosuite.shaded.org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;

public abstract class NativeJdbcExtractorAdapter
implements NativeJdbcExtractor {
    @Override
    public boolean isNativeConnectionNecessaryForNativeStatements() {
        return false;
    }

    @Override
    public boolean isNativeConnectionNecessaryForNativePreparedStatements() {
        return false;
    }

    @Override
    public boolean isNativeConnectionNecessaryForNativeCallableStatements() {
        return false;
    }

    @Override
    public Connection getNativeConnection(Connection con) throws SQLException {
        Connection metaCon;
        DatabaseMetaData metaData;
        if (con == null) {
            return null;
        }
        Connection targetCon = DataSourceUtils.getTargetConnection(con);
        Connection nativeCon = this.doGetNativeConnection(targetCon);
        if (nativeCon == targetCon && (metaData = targetCon.getMetaData()) != null && (metaCon = metaData.getConnection()) != null && metaCon != targetCon) {
            nativeCon = this.doGetNativeConnection(metaCon);
        }
        return nativeCon;
    }

    protected Connection doGetNativeConnection(Connection con) throws SQLException {
        return con;
    }

    @Override
    public Connection getNativeConnectionFromStatement(Statement stmt) throws SQLException {
        if (stmt == null) {
            return null;
        }
        return this.getNativeConnection(stmt.getConnection());
    }

    @Override
    public Statement getNativeStatement(Statement stmt) throws SQLException {
        return stmt;
    }

    @Override
    public PreparedStatement getNativePreparedStatement(PreparedStatement ps) throws SQLException {
        return ps;
    }

    @Override
    public CallableStatement getNativeCallableStatement(CallableStatement cs) throws SQLException {
        return cs;
    }

    @Override
    public ResultSet getNativeResultSet(ResultSet rs) throws SQLException {
        return rs;
    }
}

