/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.datasource.embedded;

import java.sql.Driver;
import org.evosuite.shaded.org.springframework.jdbc.datasource.embedded.AbstractEmbeddedDatabaseConfigurer;
import org.evosuite.shaded.org.springframework.jdbc.datasource.embedded.ConnectionProperties;
import org.evosuite.shaded.org.springframework.util.ClassUtils;

final class HsqlEmbeddedDatabaseConfigurer
extends AbstractEmbeddedDatabaseConfigurer {
    private static HsqlEmbeddedDatabaseConfigurer instance;
    private final Class<? extends Driver> driverClass;

    public static synchronized HsqlEmbeddedDatabaseConfigurer getInstance() throws ClassNotFoundException {
        if (instance == null) {
            instance = new HsqlEmbeddedDatabaseConfigurer(ClassUtils.forName("org.evosuite.shaded.org.hsqldb.jdbcDriver", HsqlEmbeddedDatabaseConfigurer.class.getClassLoader()));
        }
        return instance;
    }

    private HsqlEmbeddedDatabaseConfigurer(Class<? extends Driver> driverClass) {
        this.driverClass = driverClass;
    }

    @Override
    public void configureConnectionProperties(ConnectionProperties properties, String databaseName) {
        properties.setDriverClass(this.driverClass);
        properties.setUrl("jdbc:hsqldb:mem:" + databaseName);
        properties.setUsername("sa");
        properties.setPassword("");
    }
}

