/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.datasource.embedded;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.evosuite.shaded.org.apache.commons.logging.Log;
import org.evosuite.shaded.org.apache.commons.logging.LogFactory;
import org.evosuite.shaded.org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseConfigurer;

abstract class AbstractEmbeddedDatabaseConfigurer
implements EmbeddedDatabaseConfigurer {
    protected final Log logger = LogFactory.getLog(this.getClass());

    AbstractEmbeddedDatabaseConfigurer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(DataSource dataSource, String databaseName) {
        Connection con = null;
        try {
            con = dataSource.getConnection();
            con.createStatement().execute("SHUTDOWN");
        }
        catch (SQLException ex) {
            this.logger.warn("Could not shut down embedded database", ex);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (Throwable ex) {
                    this.logger.debug("Could not close JDBC Connection on shutdown", ex);
                }
            }
        }
    }
}

