/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.core.namedparam;

import java.util.HashMap;
import java.util.Map;
import org.evosuite.shaded.org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.evosuite.shaded.org.springframework.util.Assert;

public abstract class AbstractSqlParameterSource
implements SqlParameterSource {
    private final Map<String, Integer> sqlTypes = new HashMap<String, Integer>();
    private final Map<String, String> typeNames = new HashMap<String, String>();

    public void registerSqlType(String paramName, int sqlType) {
        Assert.notNull(paramName, "Parameter name must not be null");
        this.sqlTypes.put(paramName, sqlType);
    }

    public void registerTypeName(String paramName, String typeName) {
        Assert.notNull(paramName, "Parameter name must not be null");
        this.typeNames.put(paramName, typeName);
    }

    @Override
    public int getSqlType(String paramName) {
        Assert.notNull(paramName, "Parameter name must not be null");
        Integer sqlType = this.sqlTypes.get(paramName);
        if (sqlType != null) {
            return sqlType;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public String getTypeName(String paramName) {
        Assert.notNull(paramName, "Parameter name must not be null");
        return this.typeNames.get(paramName);
    }
}

