/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.cache.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.evosuite.shaded.org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.evosuite.shaded.org.springframework.cache.interceptor.CacheOperationSource;
import org.evosuite.shaded.org.springframework.util.CollectionUtils;
import org.evosuite.shaded.org.springframework.util.ObjectUtils;

abstract class CacheOperationSourcePointcut
extends StaticMethodMatcherPointcut
implements Serializable {
    CacheOperationSourcePointcut() {
    }

    @Override
    public boolean matches(Method method, Class<?> targetClass) {
        CacheOperationSource cas = this.getCacheOperationSource();
        return cas != null && !CollectionUtils.isEmpty(cas.getCacheOperations(method, targetClass));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CacheOperationSourcePointcut)) {
            return false;
        }
        CacheOperationSourcePointcut otherPc = (CacheOperationSourcePointcut)other;
        return ObjectUtils.nullSafeEquals(this.getCacheOperationSource(), otherPc.getCacheOperationSource());
    }

    public int hashCode() {
        return CacheOperationSourcePointcut.class.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getCacheOperationSource();
    }

    protected abstract CacheOperationSource getCacheOperationSource();
}

