/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.util.reflection;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SuperTypesLastSorter {
    private static final Comparator<Field> compareFieldsByName = new Comparator<Field>(){

        @Override
        public int compare(Field o1, Field o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    private SuperTypesLastSorter() {
    }

    public static List<Field> sortSuperTypesLast(Collection<? extends Field> unsortedFields) {
        ArrayList<Field> fields = new ArrayList<Field>(unsortedFields);
        Collections.sort(fields, compareFieldsByName);
        int i = 0;
        while (i < fields.size() - 1) {
            Field f = (Field)fields.get(i);
            Class<?> ft = f.getType();
            int newPos = i;
            for (int j = i + 1; j < fields.size(); ++j) {
                Class<?> t = ((Field)fields.get(j)).getType();
                if (ft == t || !ft.isAssignableFrom(t)) continue;
                newPos = j;
            }
            if (newPos == i) {
                ++i;
                continue;
            }
            fields.remove(i);
            fields.add(newPos, f);
        }
        return fields;
    }
}

