/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.util;

import org.evosuite.shaded.org.mockito.Mockito;
import org.evosuite.shaded.org.mockito.exceptions.misusing.NotAMockException;
import org.evosuite.shaded.org.mockito.internal.configuration.plugins.Plugins;
import org.evosuite.shaded.org.mockito.internal.creation.settings.CreationSettings;
import org.evosuite.shaded.org.mockito.internal.handler.MockHandlerFactory;
import org.evosuite.shaded.org.mockito.internal.stubbing.InvocationContainerImpl;
import org.evosuite.shaded.org.mockito.internal.util.MockNameImpl;
import org.evosuite.shaded.org.mockito.internal.util.reflection.LenientCopyTool;
import org.evosuite.shaded.org.mockito.invocation.MockHandler;
import org.evosuite.shaded.org.mockito.mock.MockCreationSettings;
import org.evosuite.shaded.org.mockito.mock.MockName;
import org.evosuite.shaded.org.mockito.plugins.MockMaker;

public class MockUtil {
    private static final MockMaker mockMaker = Plugins.getMockMaker();

    private MockUtil() {
    }

    public static MockMaker.TypeMockability typeMockabilityOf(Class<?> type) {
        return mockMaker.isTypeMockable(type);
    }

    public static <T> T createMock(MockCreationSettings<T> settings) {
        MockHandler<T> mockHandler = MockHandlerFactory.createMockHandler(settings);
        T mock = mockMaker.createMock(settings, mockHandler);
        Object spiedInstance = settings.getSpiedInstance();
        if (spiedInstance != null) {
            new LenientCopyTool().copyToMock(spiedInstance, mock);
        }
        return mock;
    }

    public static <T> void resetMock(T mock) {
        MockHandler<T> oldHandler = MockUtil.getMockHandler(mock);
        MockCreationSettings<T> settings = oldHandler.getMockSettings();
        MockHandler<T> newHandler = MockHandlerFactory.createMockHandler(settings);
        mockMaker.resetMock(mock, newHandler, settings);
    }

    public static <T> MockHandler<T> getMockHandler(T mock) {
        if (mock == null) {
            throw new NotAMockException("Argument should be a mock, but is null!");
        }
        if (MockUtil.isMock(mock)) {
            return mockMaker.getHandler(mock);
        }
        throw new NotAMockException("Argument should be a mock, but is: " + mock.getClass());
    }

    public static InvocationContainerImpl getInvocationContainer(Object mock) {
        return (InvocationContainerImpl)MockUtil.getMockHandler(mock).getInvocationContainer();
    }

    public static boolean isSpy(Object mock) {
        return MockUtil.isMock(mock) && MockUtil.getMockSettings(mock).getDefaultAnswer() == Mockito.CALLS_REAL_METHODS;
    }

    public static boolean isMock(Object mock) {
        return mock != null && mockMaker.getHandler(mock) != null;
    }

    public static MockName getMockName(Object mock) {
        return MockUtil.getMockHandler(mock).getMockSettings().getMockName();
    }

    public static void maybeRedefineMockName(Object mock, String newName) {
        MockName mockName = MockUtil.getMockName(mock);
        MockCreationSettings<Object> mockSettings = MockUtil.getMockHandler(mock).getMockSettings();
        if (mockName.isDefault() && mockSettings instanceof CreationSettings) {
            ((CreationSettings)mockSettings).setMockName(new MockNameImpl(newName));
        }
    }

    public static MockCreationSettings getMockSettings(Object mock) {
        return MockUtil.getMockHandler(mock).getMockSettings();
    }
}

