/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.stubbing.defaultanswers;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import org.evosuite.shaded.org.mockito.Mockito;
import org.evosuite.shaded.org.mockito.internal.debugging.LocationImpl;
import org.evosuite.shaded.org.mockito.internal.exceptions.Reporter;
import org.evosuite.shaded.org.mockito.internal.stubbing.defaultanswers.ReturnsMoreEmptyValues;
import org.evosuite.shaded.org.mockito.internal.util.ObjectMethodsGuru;
import org.evosuite.shaded.org.mockito.invocation.InvocationOnMock;
import org.evosuite.shaded.org.mockito.invocation.Location;
import org.evosuite.shaded.org.mockito.stubbing.Answer;

public class ReturnsSmartNulls
implements Answer<Object>,
Serializable {
    private static final long serialVersionUID = 7618312406617949441L;
    private final Answer<Object> delegate = new ReturnsMoreEmptyValues();

    @Override
    public Object answer(InvocationOnMock invocation) throws Throwable {
        Object defaultReturnValue = this.delegate.answer(invocation);
        if (defaultReturnValue != null) {
            return defaultReturnValue;
        }
        Class<?> type = invocation.getMethod().getReturnType();
        if (!type.isPrimitive() && !Modifier.isFinal(type.getModifiers())) {
            LocationImpl location = new LocationImpl();
            return Mockito.mock(type, new ThrowsSmartNullPointer(invocation, location));
        }
        return null;
    }

    private static class ThrowsSmartNullPointer
    implements Answer {
        private final InvocationOnMock unstubbedInvocation;
        private final Location location;

        public ThrowsSmartNullPointer(InvocationOnMock unstubbedInvocation, Location location) {
            this.unstubbedInvocation = unstubbedInvocation;
            this.location = location;
        }

        public Object answer(InvocationOnMock currentInvocation) throws Throwable {
            if (ObjectMethodsGuru.isToStringMethod(currentInvocation.getMethod())) {
                return "SmartNull returned by this unstubbed method call on a mock:\n" + this.unstubbedInvocation.toString();
            }
            throw Reporter.smartNullPointerException(this.unstubbedInvocation.toString(), this.location);
        }
    }
}

