/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.junit;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.evosuite.shaded.org.mockito.Mockito;
import org.evosuite.shaded.org.mockito.internal.exceptions.Reporter;
import org.evosuite.shaded.org.mockito.internal.listeners.StubbingLookupListener;
import org.evosuite.shaded.org.mockito.invocation.Invocation;
import org.evosuite.shaded.org.mockito.invocation.MatchableInvocation;
import org.evosuite.shaded.org.mockito.quality.Strictness;
import org.evosuite.shaded.org.mockito.stubbing.Stubbing;

class DefaultStubbingLookupListener
implements StubbingLookupListener {
    private Strictness currentStrictness;
    private boolean mismatchesReported;

    DefaultStubbingLookupListener(Strictness strictness) {
        this.currentStrictness = strictness;
    }

    @Override
    public void onStubbingLookup(Invocation invocation, MatchableInvocation stubbingFound) {
        if (this.currentStrictness != Strictness.STRICT_STUBS) {
            return;
        }
        if (stubbingFound == null) {
            List<Invocation> argMismatchStubbings = DefaultStubbingLookupListener.potentialArgMismatches(invocation);
            if (!argMismatchStubbings.isEmpty()) {
                this.mismatchesReported = true;
                Reporter.potentialStubbingProblem(invocation, argMismatchStubbings);
            }
        } else {
            invocation.markVerified();
        }
    }

    private static List<Invocation> potentialArgMismatches(Invocation invocation) {
        LinkedList<Invocation> matchingStubbings = new LinkedList<Invocation>();
        Collection<Stubbing> stubbings = Mockito.mockingDetails(invocation.getMock()).getStubbings();
        for (Stubbing s : stubbings) {
            if (s.wasUsed() || !s.getInvocation().getMethod().getName().equals(invocation.getMethod().getName())) continue;
            matchingStubbings.add(s.getInvocation());
        }
        return matchingStubbings;
    }

    void setCurrentStrictness(Strictness currentStrictness) {
        this.currentStrictness = currentStrictness;
    }

    boolean isMismatchesReported() {
        return this.mismatchesReported;
    }
}

