/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.configuration;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.evosuite.shaded.org.mockito.internal.configuration.DefaultInjectionEngine;
import org.evosuite.shaded.org.mockito.internal.configuration.IndependentAnnotationEngine;
import org.evosuite.shaded.org.mockito.internal.configuration.SpyAnnotationEngine;
import org.evosuite.shaded.org.mockito.internal.configuration.injection.scanner.InjectMocksScanner;
import org.evosuite.shaded.org.mockito.internal.configuration.injection.scanner.MockScanner;
import org.evosuite.shaded.org.mockito.internal.util.collections.Sets;
import org.evosuite.shaded.org.mockito.plugins.AnnotationEngine;

public class InjectingAnnotationEngine
implements AnnotationEngine,
org.evosuite.shaded.org.mockito.configuration.AnnotationEngine {
    private final AnnotationEngine delegate = new IndependentAnnotationEngine();
    private final AnnotationEngine spyAnnotationEngine = new SpyAnnotationEngine();

    @Override
    public void process(Class<?> clazz, Object testInstance) {
        this.processIndependentAnnotations(testInstance.getClass(), testInstance);
        this.processInjectMocks(testInstance.getClass(), testInstance);
    }

    private void processInjectMocks(Class<?> clazz, Object testInstance) {
        for (Class<?> classContext = clazz; classContext != Object.class; classContext = classContext.getSuperclass()) {
            this.injectMocks(testInstance);
        }
    }

    private void processIndependentAnnotations(Class<?> clazz, Object testInstance) {
        for (Class<?> classContext = clazz; classContext != Object.class; classContext = classContext.getSuperclass()) {
            this.delegate.process(classContext, testInstance);
            this.spyAnnotationEngine.process(classContext, testInstance);
        }
    }

    public void injectMocks(Object testClassInstance) {
        HashSet<Field> mockDependentFields = new HashSet<Field>();
        Set<Object> mocks = Sets.newMockSafeHashSet(new Object[0]);
        for (Class<?> clazz = testClassInstance.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            new InjectMocksScanner(clazz).addTo(mockDependentFields);
            new MockScanner(testClassInstance, clazz).addPreparedMocks(mocks);
            this.onInjection(testClassInstance, clazz, mockDependentFields, mocks);
        }
        new DefaultInjectionEngine().injectMocksOnFields(mockDependentFields, mocks, testClassInstance);
    }

    protected void onInjection(Object testClassInstance, Class<?> clazz, Set<Field> mockDependentFields, Set<Object> mocks) {
    }
}

