/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.configuration;

import java.io.Serializable;
import org.evosuite.shaded.org.mockito.configuration.DefaultMockitoConfiguration;
import org.evosuite.shaded.org.mockito.configuration.IMockitoConfiguration;
import org.evosuite.shaded.org.mockito.internal.configuration.ClassPathLoader;
import org.evosuite.shaded.org.mockito.internal.configuration.plugins.Plugins;
import org.evosuite.shaded.org.mockito.plugins.AnnotationEngine;
import org.evosuite.shaded.org.mockito.stubbing.Answer;

public class GlobalConfiguration
implements IMockitoConfiguration,
Serializable {
    private static final long serialVersionUID = -2860353062105505938L;
    private static final ThreadLocal<IMockitoConfiguration> GLOBAL_CONFIGURATION = new ThreadLocal();

    IMockitoConfiguration getIt() {
        return GLOBAL_CONFIGURATION.get();
    }

    public GlobalConfiguration() {
        if (GLOBAL_CONFIGURATION.get() == null) {
            GLOBAL_CONFIGURATION.set(this.createConfig());
        }
    }

    private IMockitoConfiguration createConfig() {
        DefaultMockitoConfiguration defaultConfiguration = new DefaultMockitoConfiguration();
        IMockitoConfiguration config = new ClassPathLoader().loadConfiguration();
        if (config != null) {
            return config;
        }
        return defaultConfiguration;
    }

    public static void validate() {
        new GlobalConfiguration();
    }

    @Override
    public org.evosuite.shaded.org.mockito.configuration.AnnotationEngine getAnnotationEngine() {
        return GLOBAL_CONFIGURATION.get().getAnnotationEngine();
    }

    public AnnotationEngine tryGetPluginAnnotationEngine() {
        IMockitoConfiguration configuration = GLOBAL_CONFIGURATION.get();
        if (configuration.getClass() == DefaultMockitoConfiguration.class) {
            return Plugins.getAnnotationEngine();
        }
        return configuration.getAnnotationEngine();
    }

    @Override
    public boolean cleansStackTrace() {
        return GLOBAL_CONFIGURATION.get().cleansStackTrace();
    }

    @Override
    public boolean enableClassCache() {
        return GLOBAL_CONFIGURATION.get().enableClassCache();
    }

    @Override
    public Answer<Object> getDefaultAnswer() {
        return GLOBAL_CONFIGURATION.get().getDefaultAnswer();
    }
}

