/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.types;

import java.sql.Blob;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.SessionInterface;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCBlobClient;
import org.evosuite.shaded.org.hsqldb.types.BinaryData;
import org.evosuite.shaded.org.hsqldb.types.BinaryType;
import org.evosuite.shaded.org.hsqldb.types.BlobData;
import org.evosuite.shaded.org.hsqldb.types.BlobDataID;
import org.evosuite.shaded.org.hsqldb.types.Type;

public final class BlobType
extends BinaryType {
    public static final long maxBlobPrecision = 0x10000000000L;
    public static final int defaultBlobSize = 0x40000000;
    public static final int defaultShortBlobSize = 0x1000000;

    public BlobType(long l) {
        super(30, l);
    }

    @Override
    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    @Override
    public int getJDBCTypeCode() {
        return 2004;
    }

    @Override
    public Class getJDBCClass() {
        return Blob.class;
    }

    @Override
    public String getJDBCClassName() {
        return "java.sql.Blob";
    }

    @Override
    public String getNameString() {
        return "BLOB";
    }

    @Override
    public String getFullNameString() {
        return "BINARY LARGE OBJECT";
    }

    @Override
    public String getDefinition() {
        long l = this.precision;
        String string = null;
        if (this.precision % 0x40000000L == 0L) {
            l = this.precision / 0x40000000L;
            string = "G";
        } else if (this.precision % 0x100000L == 0L) {
            l = this.precision / 0x100000L;
            string = "M";
        } else if (this.precision % 1024L == 0L) {
            l = this.precision / 1024L;
            string = "K";
        }
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(this.getNameString());
        stringBuffer.append('(');
        stringBuffer.append(l);
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    public boolean isBinaryType() {
        return true;
    }

    @Override
    public boolean isLobType() {
        return true;
    }

    @Override
    public boolean acceptsPrecision() {
        return true;
    }

    @Override
    public long getMaxPrecision() {
        return 0x10000000000L;
    }

    @Override
    public boolean requiresPrecision() {
        return false;
    }

    @Override
    public int compare(Session session, Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object2 instanceof BinaryData) {
            return session.database.lobManager.compare((BlobData)object, ((BlobData)object2).getBytes());
        }
        return session.database.lobManager.compare((BlobData)object, (BlobData)object2);
    }

    @Override
    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        return object;
    }

    @Override
    public Object castToType(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return null;
        }
        if (type.typeCode == 30) {
            BlobData blobData = (BlobData)object;
            long l = blobData.length(sessionInterface);
            if (l > this.precision) {
                l = this.precision;
                sessionInterface.addWarning(Error.error(1004));
                blobData = blobData.getBlob(sessionInterface, 0L, l);
                return blobData;
            }
            return object;
        }
        if (type.typeCode == 60 || type.typeCode == 61) {
            BlobData blobData = (BlobData)object;
            long l = blobData.length(sessionInterface);
            if (l > this.precision) {
                l = this.precision;
                sessionInterface.addWarning(Error.error(1004));
            }
            BlobDataID blobDataID = sessionInterface.createBlob(blobData.length(sessionInterface));
            blobDataID.setBytes(sessionInterface, 0L, blobData.getBytes(), 0, (int)l);
            return blobDataID;
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        BlobData blobData = null;
        if (object == null) {
            return null;
        }
        if (type.typeCode == 30) {
            blobData = (BlobData)object;
            long l = blobData.length(sessionInterface);
            if (l > this.precision) {
                throw Error.error(3401);
            }
            return object;
        }
        if (type.typeCode == 40) {
            object = Type.SQL_VARCHAR.convertToType(sessionInterface, object, type);
            type = Type.SQL_VARCHAR;
        }
        if (type.typeCode == 12 || type.typeCode == 1) {
            object = sessionInterface.getScanner().convertToBinary((String)object, false);
            type = Type.SQL_VARBINARY;
        }
        if (type.typeCode == 60 || type.typeCode == 61) {
            blobData = (BlobData)object;
            long l = blobData.length(sessionInterface);
            if (l > this.precision) {
                throw Error.error(3401);
            }
            BlobDataID blobDataID = sessionInterface.createBlob(blobData.length(sessionInterface));
            blobDataID.setBytes(sessionInterface, 0L, blobData.getBytes());
            return blobDataID;
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof JDBCBlobClient) {
            return ((JDBCBlobClient)object).getBlob();
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertSQLToJava(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BlobDataID) {
            BlobDataID blobDataID = (BlobDataID)object;
            return new JDBCBlobClient(sessionInterface, blobDataID);
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return new BinaryData((byte[])object, false);
        }
        throw Error.error(5561);
    }

    @Override
    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        return Long.toString(((BlobData)object).getId());
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        return this.convertToString(object);
    }
}

