/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb;

import org.evosuite.shaded.org.hsqldb.Expression;
import org.evosuite.shaded.org.hsqldb.HsqlException;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.Statement;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.OrderedHashSet;
import org.evosuite.shaded.org.hsqldb.result.Result;

public class StatementSignal
extends Statement {
    String sqlState;
    Expression messageExpression;

    StatementSignal(int n, String string, Expression expression) {
        super(n, 2007);
        this.references = new OrderedHashSet();
        this.isTransactionStatement = false;
        this.sqlState = string;
        this.messageExpression = expression;
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 108: {
                stringBuffer.append("SIGNAL").append(' ');
                stringBuffer.append("SQLSTATE");
                stringBuffer.append(' ').append('\'').append(this.sqlState).append('\'');
                break;
            }
            case 106: {
                stringBuffer.append("RESIGNAL").append(' ');
                stringBuffer.append("SQLSTATE");
                stringBuffer.append(' ').append('\'').append(this.sqlState).append('\'');
            }
        }
        return stringBuffer.toString();
    }

    protected String describe(Session session, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append("STATEMENT");
        return stringBuffer.toString();
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(throwable);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    Result getResult(Session session) {
        switch (this.type) {
            case 106: 
            case 108: {
                HsqlException hsqlException = Error.error(this.getMessage(session), this.sqlState);
                return Result.newErrorResult(hsqlException);
            }
        }
        throw Error.runtimeError(201, "StatementSignal");
    }

    void setMessage(Expression expression) {
        this.messageExpression = expression;
    }

    String getMessage(Session session) {
        if (this.messageExpression == null) {
            return null;
        }
        return (String)this.messageExpression.getValue(session);
    }

    @Override
    public void resolve(Session session) {
        boolean bl = false;
        switch (this.type) {
            case 106: 
            case 108: {
                bl = true;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSignal");
            }
        }
        if (!bl) {
            throw Error.error(5602);
        }
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    @Override
    public boolean isCatalogLock(int n) {
        return false;
    }

    @Override
    public boolean isCatalogChange() {
        return false;
    }
}

