/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb;

import org.evosuite.shaded.org.hsqldb.ColumnSchema;
import org.evosuite.shaded.org.hsqldb.Expression;
import org.evosuite.shaded.org.hsqldb.ExpressionAccessor;
import org.evosuite.shaded.org.hsqldb.HsqlException;
import org.evosuite.shaded.org.hsqldb.HsqlNameManager;
import org.evosuite.shaded.org.hsqldb.ParserDQL;
import org.evosuite.shaded.org.hsqldb.QueryExpression;
import org.evosuite.shaded.org.hsqldb.RangeVariable;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.SqlInvariants;
import org.evosuite.shaded.org.hsqldb.StatementDML;
import org.evosuite.shaded.org.hsqldb.StatementDMQL;
import org.evosuite.shaded.org.hsqldb.Table;
import org.evosuite.shaded.org.hsqldb.TableDerived;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.ArrayUtil;
import org.evosuite.shaded.org.hsqldb.lib.OrderedHashSet;
import org.evosuite.shaded.org.hsqldb.map.BaseHashMap;
import org.evosuite.shaded.org.hsqldb.map.ValuePool;
import org.evosuite.shaded.org.hsqldb.result.Result;
import org.evosuite.shaded.org.hsqldb.types.Type;

public class StatementSet
extends StatementDMQL {
    Expression expression;
    Expression[] targets;
    int[] variableIndexes;
    Type[] sourceTypes;
    final int operationType;
    public static final int TRIGGER_SET = 1;
    public static final int SELECT_INTO = 2;
    public static final int VARIABLE_SET = 3;

    StatementSet(Session session, Expression[] expressionArray, Table table, RangeVariable[] rangeVariableArray, int[] nArray, Expression[] expressionArray2, ParserDQL.CompileContext compileContext) {
        super(97, 2004, session.getCurrentSchemaHsqlName());
        this.operationType = 1;
        this.targets = expressionArray;
        this.targetTable = table;
        this.baseTable = this.targetTable.getBaseTable();
        this.updateColumnMap = nArray;
        this.updateExpressions = expressionArray2;
        this.updateCheckColumns = this.targetTable.getColumnCheckList(nArray);
        this.targetRangeVariables = rangeVariableArray;
        this.isTransactionStatement = false;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    StatementSet(Session session, Expression[] expressionArray, Expression expression, int[] nArray, ParserDQL.CompileContext compileContext) {
        super(97, 2007, null);
        this.operationType = 3;
        this.targets = expressionArray;
        this.expression = expression;
        this.variableIndexes = nArray;
        this.sourceTypes = this.expression.getNodeDataTypes();
        this.isTransactionStatement = false;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    StatementSet(Session session, Expression[] expressionArray, QueryExpression queryExpression, int[] nArray, ParserDQL.CompileContext compileContext) {
        super(97, 2007, null);
        this.operationType = 2;
        this.queryExpression = queryExpression;
        this.targets = expressionArray;
        this.variableIndexes = nArray;
        this.sourceTypes = queryExpression.getColumnTypes();
        this.isTransactionStatement = false;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    @Override
    TableDerived[] getSubqueries(Session session) {
        BaseHashMap baseHashMap = null;
        if (this.expression != null) {
            baseHashMap = this.expression.collectAllSubqueries((OrderedHashSet)baseHashMap);
        }
        if (baseHashMap == null || baseHashMap.size() == 0) {
            return TableDerived.emptyArray;
        }
        Object[] objectArray = new TableDerived[baseHashMap.size()];
        ((OrderedHashSet)baseHashMap).toArray(objectArray);
        for (int i = 0; i < this.subqueries.length; ++i) {
            ((TableDerived)objectArray[i]).prepareTable(session);
        }
        return objectArray;
    }

    @Override
    Result getResult(Session session) {
        Result result = null;
        switch (this.operationType) {
            case 1: {
                result = this.executeTriggerSetStatement(session);
                break;
            }
            case 2: {
                Object[] objectArray = this.queryExpression.getSingleRowValues(session);
                if (objectArray == null) {
                    session.addWarning(HsqlException.noDataCondition);
                    result = Result.updateZeroResult;
                    break;
                }
                result = StatementSet.performAssignment(session, this.variableIndexes, this.targets, objectArray, this.sourceTypes);
                break;
            }
            case 3: {
                Object[] objectArray = this.getExpressionValues(session);
                if (objectArray == null) {
                    result = Result.updateZeroResult;
                    break;
                }
                result = StatementSet.performAssignment(session, this.variableIndexes, this.targets, objectArray, this.sourceTypes);
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSet");
            }
        }
        return result;
    }

    @Override
    public void resolve(Session session) {
        switch (this.operationType) {
            case 1: {
                for (int i = 0; i < this.updateExpressions.length; ++i) {
                    this.updateExpressions[i].collectObjectNames(this.references);
                }
                break;
            }
            case 2: 
            case 3: {
                if (this.expression == null) break;
                this.expression.collectObjectNames(this.references);
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSet");
            }
        }
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.operationType) {
            case 1: {
                return this.sql;
            }
            case 3: {
                stringBuffer.append("SET").append(' ');
                stringBuffer.append(this.targets[0].getColumn().getName().statementName);
                stringBuffer.append(' ').append('=').append(' ').append(this.expression.getSQL());
            }
        }
        return stringBuffer.toString();
    }

    protected String describe(Session session, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append("STATEMENT");
        return stringBuffer.toString();
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            if (this.subqueries.length > 0) {
                this.materializeSubQueries(session);
            }
            result = this.getResult(session);
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(throwable);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    Result executeTriggerSetStatement(Session session) {
        Table table = this.targetTable;
        int[] nArray = this.updateColumnMap;
        Expression[] expressionArray = this.updateExpressions;
        Type[] typeArray = table.getColumnTypes();
        int n = this.targetRangeVariables[1].rangePosition;
        Object[] objectArray = session.sessionContext.triggerArguments[n];
        Object[] objectArray2 = StatementDML.getUpdatedData(session, this.targets, table, nArray, expressionArray, typeArray, objectArray);
        ArrayUtil.copyArray(objectArray2, objectArray, objectArray2.length);
        return Result.updateOneResult;
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet orderedHashSet) {
        int n;
        if (this.queryExpression != null) {
            this.queryExpression.getBaseTableNames(orderedHashSet);
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            Table table = this.rangeVariables[n].rangeTable;
            HsqlNameManager.HsqlName hsqlName = table.getName();
            if (table.isDataReadOnly() || table.isTemp() || table.isView() || hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            orderedHashSet.add(hsqlName);
        }
        for (n = 0; n < this.subqueries.length; ++n) {
            if (this.subqueries[n].queryExpression == null) continue;
            this.subqueries[n].queryExpression.getBaseTableNames(orderedHashSet);
        }
        for (n = 0; n < this.routines.length; ++n) {
            orderedHashSet.addAll(this.routines[n].getTableNamesForRead());
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet orderedHashSet) {
    }

    public void checkIsNotColumnTarget() {
        for (int i = 0; i < this.targets.length; ++i) {
            ColumnSchema columnSchema = this.targets[i].getColumn();
            if (columnSchema.getType() != 9) continue;
            throw Error.error(2500, columnSchema.getName().statementName);
        }
    }

    Object[] getExpressionValues(Session session) {
        Object[] objectArray;
        if (this.expression.getType() == 25) {
            objectArray = this.expression.getRowValue(session);
        } else if (this.expression.getType() == 22) {
            objectArray = this.expression.table.queryExpression.getSingleRowValues(session);
            if (objectArray == null) {
                return null;
            }
        } else {
            objectArray = new Object[]{this.expression.getValue(session)};
        }
        return objectArray;
    }

    static Result performAssignment(Session session, int[] nArray, Expression[] expressionArray, Object[] objectArray, Type[] typeArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            Type type;
            Object[] objectArray2 = ValuePool.emptyObjectArray;
            switch (expressionArray[i].getColumn().getType()) {
                case 23: {
                    objectArray2 = session.sessionContext.routineArguments;
                    break;
                }
                case 22: {
                    objectArray2 = session.sessionContext.routineVariables;
                    break;
                }
                case 9: {
                    objectArray2 = session.sessionContext.triggerArguments[1];
                }
            }
            int n = nArray[i];
            Object object = objectArray[i];
            if (expressionArray[i].getType() == 95) {
                type = expressionArray[i].getLeftNode().getColumn().getDataType().collectionBaseType();
                object = type.convertToType(session, object, typeArray[i]);
                objectArray2[n] = ((ExpressionAccessor)expressionArray[i]).getUpdatedArray(session, (Object[])objectArray2[n], object, true);
                continue;
            }
            type = expressionArray[i].getColumn().getDataType();
            objectArray2[n] = object = type.convertToType(session, object, typeArray[i]);
        }
        return Result.updateZeroResult;
    }
}

