/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb;

import org.evosuite.shaded.org.hsqldb.Expression;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.error.Error;

public class ExpressionOrderBy
extends Expression {
    private boolean isDescending;
    private boolean isNullsLast;

    ExpressionOrderBy(Expression expression) {
        super(90);
        this.nodes = new Expression[1];
        this.nodes[0] = expression;
        this.collation = expression.collation;
        expression.collation = null;
    }

    void setDescending() {
        this.isDescending = true;
    }

    boolean isDescending() {
        return this.isDescending;
    }

    void setNullsLast(boolean bl) {
        this.isNullsLast = bl;
    }

    boolean isNullsLast() {
        return this.isNullsLast;
    }

    @Override
    public Object getValue(Session session) {
        return this.nodes[0].getValue(session);
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        this.nodes[0].resolveTypes(session, expression);
        if (this.nodes[0].isUnresolvedParam()) {
            throw Error.error(5567);
        }
        this.dataType = this.nodes[0].dataType;
        if (this.collation != null && !this.dataType.isCharacterType()) {
            throw Error.error(4650, this.collation.getName().statementName);
        }
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ORDER").append(' ').append("BY").append(' ');
        if (this.nodes[0].alias != null) {
            stringBuffer.append(this.nodes[0].alias.name);
        } else {
            stringBuffer.append(this.nodes[0].getSQL());
        }
        if (this.collation != null) {
            stringBuffer.append(' ').append(this.collation.getName().getSchemaQualifiedStatementName());
        }
        if (this.isDescending) {
            stringBuffer.append(' ').append("DESC");
        }
        return stringBuffer.toString();
    }

    @Override
    protected String describe(Session session, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getLeftNode().describe(session, n));
        if (this.isDescending) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("DESC").append('\n');
        }
        return stringBuffer.toString();
    }
}

