/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.type.descriptor.sql;

import java.util.Map;
import org.evosuite.shaded.org.hibernate.internal.util.collections.BoundedConcurrentHashMap;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class NationalizedTypeMappings {
    private static final Logger log = Logger.getLogger(NationalizedTypeMappings.class);
    public static final NationalizedTypeMappings INSTANCE = new NationalizedTypeMappings();
    private final Map<Integer, Integer> nationalizedCodeByNonNationalized = new BoundedConcurrentHashMap<Integer, Integer>();

    public NationalizedTypeMappings() {
        this.map(1, -15);
        this.map(2005, 2011);
        this.map(-1, -16);
        this.map(12, -9);
    }

    private void map(int nonNationalizedCode, int nationalizedCode) {
        this.nationalizedCodeByNonNationalized.put(nonNationalizedCode, nationalizedCode);
    }

    public int getCorrespondingNationalizedCode(int jdbcCode) {
        Integer nationalizedCode = this.nationalizedCodeByNonNationalized.get(jdbcCode);
        if (nationalizedCode == null) {
            log.debug("Unable to locate nationalized jdbc-code equivalent for given jdbc code : " + jdbcCode);
            return jdbcCode;
        }
        return nationalizedCode;
    }
}

