/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.type.descriptor.java;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.annotations.Immutable;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.internal.util.ReflectHelper;
import org.evosuite.shaded.org.hibernate.type.descriptor.WrapperOptions;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.BigDecimalTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.BigIntegerTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.BlobTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.BooleanTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.ByteArrayTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.ByteTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.CalendarTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.CharacterArrayTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.CharacterTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.ClassTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.ClobTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.CurrencyTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.DateTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.DoubleTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.DurationJavaDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.EnumJavaTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.FloatTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.InstantJavaDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.IntegerTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.JdbcDateTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.JdbcTimeTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.JdbcTimestampTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.LocalDateJavaDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.LocalDateTimeJavaDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.LocaleTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.LongTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.MutabilityPlan;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.NClobTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.OffsetDateTimeJavaDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.OffsetTimeJavaDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.PrimitiveByteArrayTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.PrimitiveCharacterArrayTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.SerializableTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.ShortTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.StringTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.TimeZoneTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.UUIDTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.UrlTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.ZonedDateTimeJavaDescriptor;

public class JavaTypeDescriptorRegistry {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(JavaTypeDescriptorRegistry.class);
    public static final JavaTypeDescriptorRegistry INSTANCE = new JavaTypeDescriptorRegistry();
    private ConcurrentHashMap<Class, JavaTypeDescriptor> descriptorsByClass = new ConcurrentHashMap();

    public JavaTypeDescriptorRegistry() {
        this.addDescriptorInternal(ByteTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(BooleanTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(CharacterTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(ShortTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(IntegerTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(LongTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(FloatTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(DoubleTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(BigDecimalTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(BigIntegerTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(StringTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(BlobTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(ClobTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(NClobTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(ByteArrayTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(CharacterArrayTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(PrimitiveByteArrayTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(PrimitiveCharacterArrayTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(DurationJavaDescriptor.INSTANCE);
        this.addDescriptorInternal(InstantJavaDescriptor.INSTANCE);
        this.addDescriptorInternal(LocalDateJavaDescriptor.INSTANCE);
        this.addDescriptorInternal(LocalDateTimeJavaDescriptor.INSTANCE);
        this.addDescriptorInternal(OffsetDateTimeJavaDescriptor.INSTANCE);
        this.addDescriptorInternal(OffsetTimeJavaDescriptor.INSTANCE);
        this.addDescriptorInternal(ZonedDateTimeJavaDescriptor.INSTANCE);
        this.addDescriptorInternal(CalendarTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(DateTypeDescriptor.INSTANCE);
        this.descriptorsByClass.put(Date.class, JdbcDateTypeDescriptor.INSTANCE);
        this.descriptorsByClass.put(Time.class, JdbcTimeTypeDescriptor.INSTANCE);
        this.descriptorsByClass.put(Timestamp.class, JdbcTimestampTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(TimeZoneTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(ClassTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(CurrencyTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(LocaleTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(UrlTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(UUIDTypeDescriptor.INSTANCE);
    }

    private JavaTypeDescriptor addDescriptorInternal(JavaTypeDescriptor descriptor) {
        return this.descriptorsByClass.put(descriptor.getJavaTypeClass(), descriptor);
    }

    public void addDescriptor(JavaTypeDescriptor descriptor) {
        JavaTypeDescriptor old = this.addDescriptorInternal(descriptor);
        if (old != null) {
            log.debugf("JavaTypeDescriptorRegistry entry replaced : %s -> %s (was %s)", (Object)descriptor.getJavaTypeClass(), (Object)descriptor, (Object)old);
        }
    }

    public <T> JavaTypeDescriptor<T> getDescriptor(Class<T> cls) {
        if (cls == null) {
            throw new IllegalArgumentException("Class passed to locate Java type descriptor cannot be null");
        }
        EnumJavaTypeDescriptor<T> descriptor = this.descriptorsByClass.get(cls);
        if (descriptor != null) {
            return descriptor;
        }
        if (cls.isEnum()) {
            descriptor = new EnumJavaTypeDescriptor<T>(cls);
            this.descriptorsByClass.put(cls, descriptor);
            return descriptor;
        }
        for (Map.Entry<Class, JavaTypeDescriptor> entry : this.descriptorsByClass.entrySet()) {
            if (!entry.getKey().isAssignableFrom(cls)) continue;
            log.debugf("Using  cached JavaTypeDescriptor instance for Java class [%s]", (Object)cls.getName());
            return entry.getValue();
        }
        if (Serializable.class.isAssignableFrom(cls)) {
            return new SerializableTypeDescriptor<T>(cls);
        }
        log.debugf("Could not find matching JavaTypeDescriptor for requested Java class [%s]; using fallback.  This means Hibernate does not know how to perform certain basic operations in relation to this Java type.", (Object)cls.getName());
        this.checkEqualsAndHashCode(cls);
        return new FallbackJavaTypeDescriptor<T>(cls);
    }

    private void checkEqualsAndHashCode(Class javaType) {
        if (!ReflectHelper.overridesEquals(javaType) || !ReflectHelper.overridesHashCode(javaType)) {
            log.unknownJavaTypeNoEqualsHashCode(javaType);
        }
    }

    public static class FallbackJavaTypeDescriptor<T>
    extends AbstractTypeDescriptor<T> {
        protected FallbackJavaTypeDescriptor(Class<T> type) {
            super(type, FallbackJavaTypeDescriptor.createMutabilityPlan(type));
        }

        private static <T> MutabilityPlan<T> createMutabilityPlan(final Class<T> type) {
            if (type.isAnnotationPresent(Immutable.class)) {
                return ImmutableMutabilityPlan.INSTANCE;
            }
            return new MutableMutabilityPlan<T>(){

                @Override
                protected T deepCopyNotNull(T value) {
                    throw new HibernateException("Not known how to deep copy value of type: [" + type.getName() + "]");
                }
            };
        }

        @Override
        public String toString(T value) {
            return value == null ? "<null>" : value.toString();
        }

        @Override
        public T fromString(String string) {
            throw new HibernateException("Not known how to convert String to given type [" + this.getJavaTypeClass().getName() + "]");
        }

        @Override
        public <X> X unwrap(T value, Class<X> type, WrapperOptions options) {
            return (X)value;
        }

        @Override
        public <X> T wrap(X value, WrapperOptions options) {
            return (T)value;
        }
    }
}

