/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.tool.schema.internal;

import org.evosuite.shaded.org.hibernate.boot.Metadata;
import org.evosuite.shaded.org.hibernate.boot.model.relational.Sequence;
import org.evosuite.shaded.org.hibernate.dialect.Dialect;
import org.evosuite.shaded.org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.evosuite.shaded.org.hibernate.tool.schema.spi.Exporter;

public class StandardSequenceExporter
implements Exporter<Sequence> {
    private final Dialect dialect;

    public StandardSequenceExporter(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public String[] getSqlCreateStrings(Sequence sequence, Metadata metadata) {
        JdbcEnvironment jdbcEnvironment = metadata.getDatabase().getJdbcEnvironment();
        return this.dialect.getCreateSequenceStrings(jdbcEnvironment.getQualifiedObjectNameFormatter().format(sequence.getName(), jdbcEnvironment.getDialect()), sequence.getInitialValue(), sequence.getIncrementSize());
    }

    @Override
    public String[] getSqlDropStrings(Sequence sequence, Metadata metadata) {
        JdbcEnvironment jdbcEnvironment = metadata.getDatabase().getJdbcEnvironment();
        return this.dialect.getDropSequenceStrings(jdbcEnvironment.getQualifiedObjectNameFormatter().format(sequence.getName(), jdbcEnvironment.getDialect()));
    }
}

