/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.tool.schema.internal;

import java.util.Set;
import org.evosuite.shaded.org.hibernate.boot.Metadata;
import org.evosuite.shaded.org.hibernate.boot.model.naming.Identifier;
import org.evosuite.shaded.org.hibernate.boot.model.relational.Namespace;
import org.evosuite.shaded.org.hibernate.dialect.Dialect;
import org.evosuite.shaded.org.hibernate.engine.jdbc.internal.Formatter;
import org.evosuite.shaded.org.hibernate.mapping.Table;
import org.evosuite.shaded.org.hibernate.tool.schema.extract.spi.DatabaseInformation;
import org.evosuite.shaded.org.hibernate.tool.schema.extract.spi.NameSpaceTablesInformation;
import org.evosuite.shaded.org.hibernate.tool.schema.extract.spi.TableInformation;
import org.evosuite.shaded.org.hibernate.tool.schema.internal.AbstractSchemaMigrator;
import org.evosuite.shaded.org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.evosuite.shaded.org.hibernate.tool.schema.internal.exec.GenerationTarget;
import org.evosuite.shaded.org.hibernate.tool.schema.spi.ExecutionOptions;
import org.evosuite.shaded.org.hibernate.tool.schema.spi.SchemaFilter;

public class GroupedSchemaMigratorImpl
extends AbstractSchemaMigrator {
    public GroupedSchemaMigratorImpl(HibernateSchemaManagementTool tool, SchemaFilter schemaFilter) {
        super(tool, schemaFilter);
    }

    @Override
    protected NameSpaceTablesInformation performTablesMigration(Metadata metadata, DatabaseInformation existingDatabase, ExecutionOptions options, Dialect dialect, Formatter formatter, Set<String> exportIdentifiers, boolean tryToCreateCatalogs, boolean tryToCreateSchemas, Set<Identifier> exportedCatalogs, Namespace namespace, GenerationTarget[] targets) {
        NameSpaceTablesInformation tablesInformation = new NameSpaceTablesInformation(metadata.getDatabase().getJdbcEnvironment().getIdentifierHelper());
        if (this.schemaFilter.includeNamespace(namespace)) {
            TableInformation tableInformation;
            this.createSchemaAndCatalog(existingDatabase, options, dialect, formatter, tryToCreateCatalogs, tryToCreateSchemas, exportedCatalogs, namespace, targets);
            NameSpaceTablesInformation tables = existingDatabase.getTablesInformation(namespace);
            for (Table table : namespace.getTables()) {
                if (!this.schemaFilter.includeTable(table) || !table.isPhysicalTable()) continue;
                this.checkExportIdentifier(table, exportIdentifiers);
                tableInformation = tables.getTableInformation(table);
                if (tableInformation == null) {
                    this.createTable(table, dialect, metadata, formatter, options, targets);
                    continue;
                }
                if (tableInformation == null || !tableInformation.isPhysicalTable()) continue;
                tablesInformation.addTableInformation(tableInformation);
                this.migrateTable(table, tableInformation, dialect, metadata, formatter, options, targets);
            }
            for (Table table : namespace.getTables()) {
                if (!this.schemaFilter.includeTable(table) || !table.isPhysicalTable() || (tableInformation = tablesInformation.getTableInformation(table)) != null && (tableInformation == null || !tableInformation.isPhysicalTable())) continue;
                this.applyIndexes(table, tableInformation, dialect, metadata, formatter, options, targets);
                this.applyUniqueKeys(table, tableInformation, dialect, metadata, formatter, options, targets);
            }
        }
        return tablesInformation;
    }
}

