/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.service.internal;

import java.util.List;
import org.evosuite.shaded.org.hibernate.boot.spi.SessionFactoryOptions;
import org.evosuite.shaded.org.hibernate.engine.config.spi.ConfigurationService;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.event.service.spi.EventListenerRegistry;
import org.evosuite.shaded.org.hibernate.service.Service;
import org.evosuite.shaded.org.hibernate.service.internal.AbstractServiceRegistryImpl;
import org.evosuite.shaded.org.hibernate.service.internal.ProvidedService;
import org.evosuite.shaded.org.hibernate.service.spi.Configurable;
import org.evosuite.shaded.org.hibernate.service.spi.ServiceBinding;
import org.evosuite.shaded.org.hibernate.service.spi.ServiceInitiator;
import org.evosuite.shaded.org.hibernate.service.spi.ServiceRegistryImplementor;
import org.evosuite.shaded.org.hibernate.service.spi.SessionFactoryServiceInitiator;
import org.evosuite.shaded.org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class SessionFactoryServiceRegistryImpl
extends AbstractServiceRegistryImpl
implements SessionFactoryServiceRegistry {
    private final SessionFactoryOptions sessionFactoryOptions;
    private final SessionFactoryImplementor sessionFactory;
    private EventListenerRegistry cachedEventListenerRegistry;

    public SessionFactoryServiceRegistryImpl(ServiceRegistryImplementor parent, List<SessionFactoryServiceInitiator> initiators, List<ProvidedService> providedServices, SessionFactoryImplementor sessionFactory, SessionFactoryOptions sessionFactoryOptions) {
        super(parent);
        this.sessionFactory = sessionFactory;
        this.sessionFactoryOptions = sessionFactoryOptions;
        for (SessionFactoryServiceInitiator initiator : initiators) {
            this.createServiceBinding(initiator);
        }
        for (ProvidedService providedService : providedServices) {
            this.createServiceBinding(providedService);
        }
    }

    @Override
    public <R extends Service> R initiateService(ServiceInitiator<R> serviceInitiator) {
        SessionFactoryServiceInitiator sessionFactoryServiceInitiator = (SessionFactoryServiceInitiator)serviceInitiator;
        return sessionFactoryServiceInitiator.initiateService(this.sessionFactory, this.sessionFactoryOptions, this);
    }

    @Override
    public <R extends Service> void configureService(ServiceBinding<R> serviceBinding) {
        if (Configurable.class.isInstance(serviceBinding.getService())) {
            ((Configurable)serviceBinding.getService()).configure(this.getService(ConfigurationService.class).getSettings());
        }
    }

    @Override
    public <R extends Service> R getService(Class<R> serviceRole) {
        if (serviceRole.equals(EventListenerRegistry.class)) {
            if (this.cachedEventListenerRegistry == null) {
                this.cachedEventListenerRegistry = (EventListenerRegistry)super.getService(serviceRole);
            }
            return (R)this.cachedEventListenerRegistry;
        }
        return super.getService(serviceRole);
    }
}

