/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.resource.transaction.spi;

import org.evosuite.shaded.org.hibernate.engine.transaction.spi.IsolationDelegate;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.TransactionObserver;
import org.evosuite.shaded.org.hibernate.resource.transaction.spi.SynchronizationRegistry;
import org.evosuite.shaded.org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.evosuite.shaded.org.hibernate.resource.transaction.spi.TransactionStatus;

public interface TransactionCoordinator {
    public void explicitJoin();

    public boolean isJoined();

    public void pulse();

    public TransactionDriver getTransactionDriverControl();

    public SynchronizationRegistry getLocalSynchronizations();

    public boolean isActive();

    public IsolationDelegate createIsolationDelegate();

    public void addObserver(TransactionObserver var1);

    public void removeObserver(TransactionObserver var1);

    public TransactionCoordinatorBuilder getTransactionCoordinatorBuilder();

    public void setTimeOut(int var1);

    public int getTimeOut();

    default public boolean isTransactionActive() {
        return this.isTransactionActive(true);
    }

    default public boolean isTransactionActive(boolean isMarkedRollbackConsideredActive) {
        return this.isJoined() && this.getTransactionDriverControl().isActive(isMarkedRollbackConsideredActive);
    }

    public static interface TransactionDriver {
        public void begin();

        public void commit();

        public void rollback();

        public TransactionStatus getStatus();

        public void markRollbackOnly();

        default public boolean isActive(boolean isMarkedRollbackConsideredActive) {
            TransactionStatus status = this.getStatus();
            return TransactionStatus.ACTIVE == status || isMarkedRollbackConsideredActive && TransactionStatus.MARKED_ROLLBACK == status;
        }
    }
}

