/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.proxy.pojo.bytebuddy;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.evosuite.shaded.net.bytebuddy.ByteBuddy;
import org.evosuite.shaded.net.bytebuddy.NamingStrategy;
import org.evosuite.shaded.net.bytebuddy.TypeCache;
import org.evosuite.shaded.net.bytebuddy.description.modifier.Visibility;
import org.evosuite.shaded.net.bytebuddy.dynamic.scaffold.TypeValidation;
import org.evosuite.shaded.net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import org.evosuite.shaded.net.bytebuddy.implementation.FieldAccessor;
import org.evosuite.shaded.net.bytebuddy.implementation.MethodDelegation;
import org.evosuite.shaded.net.bytebuddy.implementation.SuperMethodCall;
import org.evosuite.shaded.net.bytebuddy.implementation.bytecode.assign.Assigner;
import org.evosuite.shaded.net.bytebuddy.matcher.ElementMatchers;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.internal.util.ReflectHelper;
import org.evosuite.shaded.org.hibernate.internal.util.collections.ArrayHelper;
import org.evosuite.shaded.org.hibernate.proxy.HibernateProxy;
import org.evosuite.shaded.org.hibernate.proxy.ProxyConfiguration;
import org.evosuite.shaded.org.hibernate.proxy.ProxyFactory;
import org.evosuite.shaded.org.hibernate.proxy.pojo.bytebuddy.ByteBuddyInterceptor;
import org.evosuite.shaded.org.hibernate.proxy.pojo.bytebuddy.SerializableProxy;
import org.evosuite.shaded.org.hibernate.type.CompositeType;

public class ByteBuddyProxyFactory
implements ProxyFactory,
Serializable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ByteBuddyProxyFactory.class);
    private static final TypeCache<TypeCache.SimpleKey> CACHE = new TypeCache.WithInlineExpunction<TypeCache.SimpleKey>(TypeCache.Sort.SOFT);
    private Class persistentClass;
    private String entityName;
    private Class[] interfaces;
    private Method getIdentifierMethod;
    private Method setIdentifierMethod;
    private CompositeType componentIdType;
    private boolean overridesEquals;
    private Class proxyClass;

    @Override
    public void postInstantiate(String entityName, Class persistentClass, Set<Class> interfaces, Method getIdentifierMethod, Method setIdentifierMethod, CompositeType componentIdType) throws HibernateException {
        this.entityName = entityName;
        this.persistentClass = persistentClass;
        this.interfaces = this.toArray(interfaces);
        this.getIdentifierMethod = getIdentifierMethod;
        this.setIdentifierMethod = setIdentifierMethod;
        this.componentIdType = componentIdType;
        this.overridesEquals = ReflectHelper.overridesEquals(persistentClass);
        this.proxyClass = ByteBuddyProxyFactory.buildProxy(persistentClass, this.interfaces);
    }

    private Class[] toArray(Set<Class> interfaces) {
        if (interfaces == null) {
            return ArrayHelper.EMPTY_CLASS_ARRAY;
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public static Class buildProxy(Class persistentClass, Class[] interfaces) {
        HashSet<Class> key = new HashSet<Class>();
        if (interfaces.length == 1) {
            key.add(persistentClass);
        }
        key.addAll(Arrays.asList(interfaces));
        return CACHE.findOrInsert(persistentClass.getClassLoader(), new TypeCache.SimpleKey(key), () -> new ByteBuddy().ignore(ElementMatchers.isSynthetic().and(ElementMatchers.named("getMetaClass").and(ElementMatchers.returns(td -> "groovy.lang.MetaClass".equals(td.getName()))))).with(TypeValidation.DISABLED).with(new NamingStrategy.SuffixingRandom("HibernateProxy")).subclass(interfaces.length == 1 ? persistentClass : Object.class, (ConstructorStrategy)ConstructorStrategy.Default.IMITATE_SUPER_CLASS_OPENING).implement(interfaces).method(ElementMatchers.isVirtual().and(ElementMatchers.not(ElementMatchers.isFinalizer()))).intercept(MethodDelegation.to(ProxyConfiguration.InterceptorDispatcher.class)).method(ElementMatchers.nameStartsWith("$$_hibernate_").and(ElementMatchers.isVirtual())).intercept(SuperMethodCall.INSTANCE).defineField("$$_hibernate_interceptor", (Type)((Object)ProxyConfiguration.Interceptor.class), Visibility.PRIVATE).implement(new Type[]{ProxyConfiguration.class}).intercept(FieldAccessor.ofField("$$_hibernate_interceptor").withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC)).make().load(persistentClass.getClassLoader()).getLoaded(), CACHE);
    }

    @Override
    public HibernateProxy getProxy(Serializable id, SharedSessionContractImplementor session) throws HibernateException {
        ByteBuddyInterceptor interceptor = new ByteBuddyInterceptor(this.entityName, this.persistentClass, this.interfaces, id, this.getIdentifierMethod, this.setIdentifierMethod, this.componentIdType, session, this.overridesEquals);
        try {
            HibernateProxy proxy = (HibernateProxy)this.proxyClass.newInstance();
            ((ProxyConfiguration)((Object)proxy)).$$_hibernate_set_interceptor(interceptor);
            return proxy;
        }
        catch (Throwable t) {
            LOG.error(LOG.bytecodeEnhancementFailed(this.entityName), t);
            throw new HibernateException(LOG.bytecodeEnhancementFailed(this.entityName), t);
        }
    }

    public static HibernateProxy deserializeProxy(SerializableProxy serializableProxy) {
        ByteBuddyInterceptor interceptor = new ByteBuddyInterceptor(serializableProxy.getEntityName(), serializableProxy.getPersistentClass(), serializableProxy.getInterfaces(), serializableProxy.getId(), ByteBuddyProxyFactory.resolveIdGetterMethod(serializableProxy), ByteBuddyProxyFactory.resolveIdSetterMethod(serializableProxy), serializableProxy.getComponentIdType(), null, ReflectHelper.overridesEquals(serializableProxy.getPersistentClass()));
        try {
            Class proxyClass = ByteBuddyProxyFactory.buildProxy(serializableProxy.getPersistentClass(), serializableProxy.getInterfaces());
            HibernateProxy proxy = (HibernateProxy)proxyClass.newInstance();
            ((ProxyConfiguration)((Object)proxy)).$$_hibernate_set_interceptor(interceptor);
            return proxy;
        }
        catch (Throwable t) {
            String message = LOG.bytecodeEnhancementFailed(serializableProxy.getEntityName());
            LOG.error(message, t);
            throw new HibernateException(message, t);
        }
    }

    private static Method resolveIdGetterMethod(SerializableProxy serializableProxy) {
        if (serializableProxy.getIdentifierGetterMethodName() == null) {
            return null;
        }
        try {
            return serializableProxy.getIdentifierGetterMethodClass().getDeclaredMethod(serializableProxy.getIdentifierGetterMethodName(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new HibernateException(String.format(Locale.ENGLISH, "Unable to deserialize proxy [%s, %s]; could not locate id getter method [%s] on entity class [%s]", serializableProxy.getEntityName(), serializableProxy.getId(), serializableProxy.getIdentifierGetterMethodName(), serializableProxy.getIdentifierGetterMethodClass()));
        }
    }

    private static Method resolveIdSetterMethod(SerializableProxy serializableProxy) {
        if (serializableProxy.getIdentifierSetterMethodName() == null) {
            return null;
        }
        try {
            return serializableProxy.getIdentifierSetterMethodClass().getDeclaredMethod(serializableProxy.getIdentifierSetterMethodName(), serializableProxy.getIdentifierSetterMethodParams());
        }
        catch (NoSuchMethodException e) {
            throw new HibernateException(String.format(Locale.ENGLISH, "Unable to deserialize proxy [%s, %s]; could not locate id setter method [%s] on entity class [%s]", serializableProxy.getEntityName(), serializableProxy.getId(), serializableProxy.getIdentifierSetterMethodName(), serializableProxy.getIdentifierSetterMethodClass()));
        }
    }
}

