/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.procedure.internal;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Parameter;
import javax.persistence.ParameterMode;
import javax.persistence.TemporalType;
import javax.persistence.TransactionRequiredException;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.QueryException;
import org.evosuite.shaded.org.hibernate.engine.ResultSetMappingDefinition;
import org.evosuite.shaded.org.hibernate.engine.jdbc.env.spi.ExtractedDatabaseMetaData;
import org.evosuite.shaded.org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.evosuite.shaded.org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;
import org.evosuite.shaded.org.hibernate.engine.spi.QueryParameters;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.internal.util.StringHelper;
import org.evosuite.shaded.org.hibernate.internal.util.collections.CollectionHelper;
import org.evosuite.shaded.org.hibernate.persister.entity.EntityPersister;
import org.evosuite.shaded.org.hibernate.procedure.NoSuchParameterException;
import org.evosuite.shaded.org.hibernate.procedure.ParameterRegistration;
import org.evosuite.shaded.org.hibernate.procedure.ParameterStrategyException;
import org.evosuite.shaded.org.hibernate.procedure.ProcedureCall;
import org.evosuite.shaded.org.hibernate.procedure.ProcedureCallMemento;
import org.evosuite.shaded.org.hibernate.procedure.ProcedureOutputs;
import org.evosuite.shaded.org.hibernate.procedure.internal.AbstractParameterRegistrationImpl;
import org.evosuite.shaded.org.hibernate.procedure.internal.NamedParameterRegistration;
import org.evosuite.shaded.org.hibernate.procedure.internal.PositionalParameterRegistration;
import org.evosuite.shaded.org.hibernate.procedure.internal.ProcedureCallMementoImpl;
import org.evosuite.shaded.org.hibernate.procedure.internal.ProcedureOutputsImpl;
import org.evosuite.shaded.org.hibernate.procedure.internal.Util;
import org.evosuite.shaded.org.hibernate.procedure.spi.ParameterRegistrationImplementor;
import org.evosuite.shaded.org.hibernate.procedure.spi.ParameterStrategy;
import org.evosuite.shaded.org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.evosuite.shaded.org.hibernate.query.QueryParameter;
import org.evosuite.shaded.org.hibernate.query.internal.AbstractProducedQuery;
import org.evosuite.shaded.org.hibernate.query.procedure.internal.ProcedureParameterImpl;
import org.evosuite.shaded.org.hibernate.query.procedure.internal.ProcedureParameterMetadata;
import org.evosuite.shaded.org.hibernate.result.NoMoreReturnsException;
import org.evosuite.shaded.org.hibernate.result.Output;
import org.evosuite.shaded.org.hibernate.result.ResultSetOutput;
import org.evosuite.shaded.org.hibernate.result.UpdateCountOutput;
import org.evosuite.shaded.org.hibernate.result.spi.ResultContext;
import org.evosuite.shaded.org.hibernate.type.Type;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class ProcedureCallImpl<R>
extends AbstractProducedQuery<R>
implements ProcedureCallImplementor<R>,
ResultContext {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, ProcedureCallImpl.class.getName());
    private static final NativeSQLQueryReturn[] NO_RETURNS = new NativeSQLQueryReturn[0];
    private final String procedureName;
    private final NativeSQLQueryReturn[] queryReturns;
    private final boolean globalParameterPassNullsSetting;
    private ParameterStrategy parameterStrategy = ParameterStrategy.UNKNOWN;
    private List<ParameterRegistrationImplementor<?>> registeredParameters = new ArrayList();
    private Set<String> synchronizedQuerySpaces;
    private ProcedureOutputsImpl outputs;
    private ProcedureOutputs procedureResult;

    public ProcedureCallImpl(SharedSessionContractImplementor session, String procedureName) {
        super(session, new ProcedureParameterMetadata());
        this.procedureName = procedureName;
        this.globalParameterPassNullsSetting = session.getFactory().getSessionFactoryOptions().isProcedureParameterNullPassingEnabled();
        this.queryReturns = NO_RETURNS;
    }

    public ProcedureCallImpl(final SharedSessionContractImplementor session, String procedureName, Class ... resultClasses) {
        super(session, new ProcedureParameterMetadata());
        this.procedureName = procedureName;
        this.globalParameterPassNullsSetting = session.getFactory().getSessionFactoryOptions().isProcedureParameterNullPassingEnabled();
        final ArrayList collectedQueryReturns = new ArrayList();
        final HashSet<String> collectedQuerySpaces = new HashSet<String>();
        Util.resolveResultClasses(new Util.ResultClassesResolutionContext(){

            @Override
            public SessionFactoryImplementor getSessionFactory() {
                return session.getFactory();
            }

            @Override
            public void addQueryReturns(NativeSQLQueryReturn ... queryReturns) {
                Collections.addAll(collectedQueryReturns, queryReturns);
            }

            @Override
            public void addQuerySpaces(String ... spaces) {
                Collections.addAll(collectedQuerySpaces, spaces);
            }
        }, resultClasses);
        this.queryReturns = collectedQueryReturns.toArray(new NativeSQLQueryReturn[collectedQueryReturns.size()]);
        this.synchronizedQuerySpaces = collectedQuerySpaces;
    }

    public ProcedureCallImpl(final SharedSessionContractImplementor session, String procedureName, String ... resultSetMappings) {
        super(session, new ProcedureParameterMetadata());
        this.procedureName = procedureName;
        this.globalParameterPassNullsSetting = session.getFactory().getSessionFactoryOptions().isProcedureParameterNullPassingEnabled();
        final ArrayList collectedQueryReturns = new ArrayList();
        final HashSet<String> collectedQuerySpaces = new HashSet<String>();
        Util.resolveResultSetMappings(new Util.ResultSetMappingResolutionContext(){

            @Override
            public SessionFactoryImplementor getSessionFactory() {
                return session.getFactory();
            }

            @Override
            public ResultSetMappingDefinition findResultSetMapping(String name) {
                return session.getFactory().getNamedQueryRepository().getResultSetMappingDefinition(name);
            }

            @Override
            public void addQueryReturns(NativeSQLQueryReturn ... queryReturns) {
                Collections.addAll(collectedQueryReturns, queryReturns);
            }

            @Override
            public void addQuerySpaces(String ... spaces) {
                Collections.addAll(collectedQuerySpaces, spaces);
            }
        }, resultSetMappings);
        this.queryReturns = collectedQueryReturns.toArray(new NativeSQLQueryReturn[collectedQueryReturns.size()]);
        this.synchronizedQuerySpaces = collectedQuerySpaces;
    }

    ProcedureCallImpl(SharedSessionContractImplementor session, ProcedureCallMementoImpl memento) {
        super(session, new ProcedureParameterMetadata());
        this.procedureName = memento.getProcedureName();
        this.globalParameterPassNullsSetting = session.getFactory().getSessionFactoryOptions().isProcedureParameterNullPassingEnabled();
        this.queryReturns = memento.getQueryReturns();
        this.synchronizedQuerySpaces = Util.copy(memento.getSynchronizedQuerySpaces());
        this.parameterStrategy = memento.getParameterStrategy();
        if (this.parameterStrategy == ParameterStrategy.UNKNOWN) {
            return;
        }
        List<ProcedureCallMementoImpl.ParameterMemento> storedRegistrations = memento.getParameterDeclarations();
        if (storedRegistrations == null) {
            LOG.debugf("ParameterStrategy was [%s] on named copy [%s], but no parameters stored", (Object)this.parameterStrategy, (Object)this.procedureName);
            return;
        }
        ArrayList parameterRegistrations = CollectionHelper.arrayList(storedRegistrations.size());
        for (ProcedureCallMementoImpl.ParameterMemento parameterMemento : storedRegistrations) {
            AbstractParameterRegistrationImpl registration;
            if (StringHelper.isNotEmpty(parameterMemento.getName())) {
                if (this.parameterStrategy != ParameterStrategy.NAMED) {
                    throw new IllegalStateException("Found named stored procedure parameter associated with positional parameters");
                }
                registration = new NamedParameterRegistration(this, parameterMemento.getName(), parameterMemento.getMode(), parameterMemento.getType(), parameterMemento.getHibernateType(), parameterMemento.isPassNullsEnabled());
            } else {
                if (this.parameterStrategy != ParameterStrategy.POSITIONAL) {
                    throw new IllegalStateException("Found named stored procedure parameter associated with positional parameters");
                }
                registration = new PositionalParameterRegistration(this, parameterMemento.getPosition(), parameterMemento.getMode(), parameterMemento.getType(), parameterMemento.getHibernateType(), parameterMemento.isPassNullsEnabled());
            }
            this.getParameterMetadata().registerParameter(new ProcedureParameterImpl(registration));
            parameterRegistrations.add(registration);
        }
        this.registeredParameters = parameterRegistrations;
        for (Map.Entry entry : memento.getHintsMap().entrySet()) {
            this.setHint((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public ProcedureParameterMetadata getParameterMetadata() {
        return (ProcedureParameterMetadata)super.getParameterMetadata();
    }

    @Override
    public SharedSessionContractImplementor getSession() {
        return this.getProducer();
    }

    public ParameterStrategy getParameterStrategy() {
        return this.parameterStrategy;
    }

    @Override
    public String getProcedureName() {
        return this.procedureName;
    }

    @Override
    public String getSql() {
        return this.getProcedureName();
    }

    @Override
    public NativeSQLQueryReturn[] getQueryReturns() {
        return this.queryReturns;
    }

    @Override
    public <T> ParameterRegistration<T> registerParameter(int position, Class<T> type, ParameterMode mode) {
        PositionalParameterRegistration<T> parameterRegistration = new PositionalParameterRegistration<T>(this, position, mode, type, this.globalParameterPassNullsSetting);
        this.registerParameter(parameterRegistration);
        return parameterRegistration;
    }

    @Override
    public ProcedureCall registerParameter0(int position, Class type, ParameterMode mode) {
        this.registerParameter(position, type, mode);
        return this;
    }

    private void registerParameter(ParameterRegistrationImplementor parameter) {
        if (StringHelper.isNotEmpty(parameter.getName())) {
            this.prepareForNamedParameters();
        } else if (parameter.getPosition() != null) {
            this.prepareForPositionalParameters();
        } else {
            throw new IllegalArgumentException("Given parameter did not define name or position [" + parameter + "]");
        }
        this.getParameterMetadata().registerParameter(new ProcedureParameterImpl(parameter));
        this.registeredParameters.add(parameter);
    }

    private void prepareForPositionalParameters() {
        if (this.parameterStrategy == ParameterStrategy.NAMED) {
            throw new QueryException("Cannot mix named and positional parameters");
        }
        this.parameterStrategy = ParameterStrategy.POSITIONAL;
    }

    private void prepareForNamedParameters() {
        if (this.parameterStrategy == ParameterStrategy.POSITIONAL) {
            throw new QueryException("Cannot mix named and positional parameters");
        }
        if (this.parameterStrategy == ParameterStrategy.UNKNOWN) {
            ExtractedDatabaseMetaData databaseMetaData = this.getSession().getJdbcCoordinator().getJdbcSessionOwner().getJdbcSessionContext().getServiceRegistry().getService(JdbcEnvironment.class).getExtractedDatabaseMetaData();
            if (!databaseMetaData.supportsNamedParameters()) {
                LOG.unsupportedNamedParameters();
            }
            this.parameterStrategy = ParameterStrategy.NAMED;
        }
    }

    @Override
    public ParameterRegistrationImplementor getParameterRegistration(int position) {
        if (this.parameterStrategy != ParameterStrategy.POSITIONAL) {
            throw new ParameterStrategyException("Attempt to access positional parameter [" + position + "] but ProcedureCall using named parameters");
        }
        for (ParameterRegistrationImplementor<?> parameter : this.registeredParameters) {
            if (position != parameter.getPosition()) continue;
            return parameter;
        }
        throw new NoSuchParameterException("Could not locate parameter registered using that position [" + position + "]");
    }

    @Override
    public <T> ParameterRegistration<T> registerParameter(String name, Class<T> type, ParameterMode mode) {
        NamedParameterRegistration<T> parameterRegistration = new NamedParameterRegistration<T>(this, name, mode, type, this.globalParameterPassNullsSetting);
        this.registerParameter(parameterRegistration);
        return parameterRegistration;
    }

    @Override
    public ProcedureCall registerParameter0(String name, Class type, ParameterMode mode) {
        this.registerParameter(name, type, mode);
        return this;
    }

    @Override
    public ParameterRegistrationImplementor getParameterRegistration(String name) {
        if (this.parameterStrategy != ParameterStrategy.NAMED) {
            throw new ParameterStrategyException("Names were not used to register parameters with this stored procedure call");
        }
        for (ParameterRegistrationImplementor<?> parameter : this.registeredParameters) {
            if (!name.equals(parameter.getName())) continue;
            return parameter;
        }
        throw new NoSuchParameterException("Could not locate parameter registered under that name [" + name + "]");
    }

    @Override
    public List<ParameterRegistration> getRegisteredParameters() {
        return new ArrayList<ParameterRegistration>(this.registeredParameters);
    }

    @Override
    public ProcedureOutputs getOutputs() {
        if (this.outputs == null) {
            this.outputs = this.buildOutputs();
        }
        return this.outputs;
    }

    private ProcedureOutputsImpl buildOutputs() {
        String call = this.getProducer().getJdbcServices().getJdbcEnvironment().getDialect().getCallableStatementSupport().renderCallableStatement(this.procedureName, this.parameterStrategy, this.registeredParameters, this.getProducer());
        try {
            LOG.debugf("Preparing procedure call : %s", (Object)call);
            CallableStatement statement = (CallableStatement)this.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement(call, true);
            int i = 1;
            for (ParameterRegistrationImplementor<?> parameter : this.registeredParameters) {
                parameter.prepare(statement, i);
                if (parameter.getMode() == ParameterMode.REF_CURSOR) {
                    ++i;
                    continue;
                }
                i += parameter.getSqlTypes().length;
            }
            return new ProcedureOutputsImpl(this, statement);
        }
        catch (SQLException e) {
            throw this.getSession().getJdbcServices().getSqlExceptionHelper().convert(e, "Error preparing CallableStatement", this.getProcedureName());
        }
    }

    @Override
    public String getQueryString() {
        return null;
    }

    @Override
    public String[] getReturnAliases() {
        throw new UnsupportedOperationException("Procedure/function calls do not support returning aliases");
    }

    @Override
    public Type[] getReturnTypes() {
        throw new UnsupportedOperationException("Procedure/function calls do not support returning 'return types'");
    }

    @Override
    public ProcedureCallImplementor<R> setEntity(int position, Object val) {
        return null;
    }

    @Override
    public ProcedureCallImplementor<R> setEntity(String name, Object val) {
        return null;
    }

    protected Set<String> synchronizedQuerySpaces() {
        if (this.synchronizedQuerySpaces == null) {
            this.synchronizedQuerySpaces = new HashSet<String>();
        }
        return this.synchronizedQuerySpaces;
    }

    @Override
    public Set<String> getSynchronizedQuerySpaces() {
        if (this.synchronizedQuerySpaces == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.synchronizedQuerySpaces);
    }

    @Override
    public ProcedureCallImplementor<R> addSynchronizedQuerySpace(String querySpace) {
        this.synchronizedQuerySpaces().add(querySpace);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> addSynchronizedEntityName(String entityName) {
        this.addSynchronizedQuerySpaces(this.getSession().getFactory().getMetamodel().entityPersister(entityName));
        return this;
    }

    protected void addSynchronizedQuerySpaces(EntityPersister persister) {
        this.synchronizedQuerySpaces().addAll(Arrays.asList((String[])persister.getQuerySpaces()));
    }

    @Override
    public ProcedureCallImplementor<R> addSynchronizedEntityClass(Class entityClass) {
        this.addSynchronizedQuerySpaces(this.getSession().getFactory().getMetamodel().entityPersister(entityClass.getName()));
        return this;
    }

    @Override
    protected boolean isNativeQuery() {
        return false;
    }

    @Override
    public QueryParameters getQueryParameters() {
        QueryParameters qp = super.getQueryParameters();
        qp.setAutoDiscoverScalarTypes(true);
        qp.setCallable(true);
        return qp;
    }

    public ParameterRegistrationImplementor[] collectRefCursorParameters() {
        ArrayList refCursorParams = new ArrayList();
        for (ParameterRegistrationImplementor<?> param : this.registeredParameters) {
            if (param.getMode() != ParameterMode.REF_CURSOR) continue;
            refCursorParams.add(param);
        }
        return refCursorParams.toArray(new ParameterRegistrationImplementor[refCursorParams.size()]);
    }

    @Override
    public ProcedureCallMemento extractMemento(Map<String, Object> hints) {
        return new ProcedureCallMementoImpl(this.procedureName, Util.copy(this.queryReturns), this.parameterStrategy, ProcedureCallImpl.toParameterMementos(this.registeredParameters), Util.copy(this.synchronizedQuerySpaces), Util.copy(hints));
    }

    @Override
    public ProcedureCallMemento extractMemento() {
        return new ProcedureCallMementoImpl(this.procedureName, Util.copy(this.queryReturns), this.parameterStrategy, ProcedureCallImpl.toParameterMementos(this.registeredParameters), Util.copy(this.synchronizedQuerySpaces), Util.copy(this.getHints()));
    }

    private static List<ProcedureCallMementoImpl.ParameterMemento> toParameterMementos(List<ParameterRegistrationImplementor<?>> registeredParameters) {
        if (registeredParameters == null) {
            return null;
        }
        ArrayList<ProcedureCallMementoImpl.ParameterMemento> copy = CollectionHelper.arrayList(registeredParameters.size());
        for (ParameterRegistrationImplementor<?> registration : registeredParameters) {
            copy.add(ProcedureCallMementoImpl.ParameterMemento.fromRegistration(registration));
        }
        return copy;
    }

    @Override
    public ProcedureCallImplementor<R> registerStoredProcedureParameter(int position, Class type, ParameterMode mode) {
        this.getProducer().checkOpen(true);
        try {
            this.registerParameter(position, type, mode);
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getProducer().markForRollbackOnly();
            throw e;
        }
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> registerStoredProcedureParameter(String parameterName, Class type, ParameterMode mode) {
        this.getProducer().checkOpen(true);
        try {
            this.registerParameter(parameterName, type, mode);
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getProducer().markForRollbackOnly();
            throw e;
        }
        return this;
    }

    @Override
    public boolean execute() {
        try {
            Output rtn = this.outputs().getCurrent();
            return rtn != null && ResultSetOutput.class.isInstance(rtn);
        }
        catch (NoMoreReturnsException e) {
            return false;
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getProducer().markForRollbackOnly();
            throw e;
        }
    }

    protected ProcedureOutputs outputs() {
        if (this.procedureResult == null) {
            this.procedureResult = this.getOutputs();
        }
        return this.procedureResult;
    }

    @Override
    public int executeUpdate() {
        if (!this.getProducer().isTransactionInProgress()) {
            throw new TransactionRequiredException("javax.persistence.Query.executeUpdate requires active transaction");
        }
        try {
            this.execute();
            int n = this.getUpdateCount();
            return n;
        }
        finally {
            this.outputs().release();
        }
    }

    @Override
    public Object getOutputParameterValue(int position) {
        try {
            return this.outputs().getOutputParameterValue(position);
        }
        catch (ParameterStrategyException e) {
            throw new IllegalArgumentException("Invalid mix of named and positional parameters", e);
        }
        catch (NoSuchParameterException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Object getOutputParameterValue(String parameterName) {
        try {
            return this.outputs().getOutputParameterValue(parameterName);
        }
        catch (ParameterStrategyException e) {
            throw new IllegalArgumentException("Invalid mix of named and positional parameters", e);
        }
        catch (NoSuchParameterException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public boolean hasMoreResults() {
        return this.outputs().goToNext() && ResultSetOutput.class.isInstance(this.outputs().getCurrent());
    }

    @Override
    public int getUpdateCount() {
        try {
            Output rtn = this.outputs().getCurrent();
            if (rtn == null) {
                return -1;
            }
            if (UpdateCountOutput.class.isInstance(rtn)) {
                return ((UpdateCountOutput)rtn).getUpdateCount();
            }
            return -1;
        }
        catch (NoMoreReturnsException e) {
            return -1;
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getProducer().markForRollbackOnly();
            throw e;
        }
    }

    @Override
    public List<R> getResultList() {
        if (this.getMaxResults() == 0) {
            return Collections.EMPTY_LIST;
        }
        try {
            Output rtn = this.outputs().getCurrent();
            if (!ResultSetOutput.class.isInstance(rtn)) {
                throw new IllegalStateException("Current CallableStatement ou was not a ResultSet, but getResultList was called");
            }
            return ((ResultSetOutput)rtn).getResultList();
        }
        catch (NoMoreReturnsException e) {
            return null;
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getProducer().markForRollbackOnly();
            throw e;
        }
    }

    @Override
    public R getSingleResult() {
        List<R> resultList = this.getResultList();
        if (resultList == null || resultList.isEmpty()) {
            throw new NoResultException(String.format("Call to stored procedure [%s] returned no results", this.getProcedureName()));
        }
        if (resultList.size() > 1) {
            throw new NonUniqueResultException(String.format("Call to stored procedure [%s] returned multiple results", this.getProcedureName()));
        }
        return resultList.get(0);
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        if (cls.isInstance(this)) {
            return (T)this;
        }
        if (cls.isInstance(this.outputs)) {
            return (T)this.outputs();
        }
        return super.unwrap(cls);
    }

    @Override
    public ProcedureCallImplementor<R> setLockMode(LockModeType lockMode) {
        throw new IllegalStateException("javax.persistence.Query.setLockMode not valid on javax.persistence.StoredProcedureQuery");
    }

    @Override
    public LockModeType getLockMode() {
        throw new IllegalStateException("javax.persistence.Query.getHibernateFlushMode not valid on javax.persistence.StoredProcedureQuery");
    }

    @Override
    public ProcedureCallImplementor<R> setHint(String hintName, Object value) {
        super.setHint(hintName, value);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setFlushMode(FlushModeType flushModeType) {
        super.setFlushMode(flushModeType);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(QueryParameter<P> parameter, P value) {
        this.locateParameterRegistration(parameter).bindValue(value);
        return this;
    }

    private <P> ParameterRegistrationImplementor<P> locateParameterRegistration(Parameter<P> parameter) {
        if (parameter.getName() != null) {
            return this.locateParameterRegistration(parameter.getName());
        }
        if (parameter.getPosition() != null) {
            return this.locateParameterRegistration(parameter.getPosition());
        }
        throw this.getExceptionConverter().convert(new IllegalArgumentException("Could not resolve registration for given parameter reference [" + parameter + "]"));
    }

    private <P> ParameterRegistrationImplementor<P> locateParameterRegistration(String name) {
        assert (name != null);
        if (this.parameterStrategy == ParameterStrategy.POSITIONAL) {
            throw new IllegalArgumentException("Expecting positional parameter");
        }
        for (ParameterRegistrationImplementor<?> registeredParameter : this.registeredParameters) {
            if (!name.equals(registeredParameter.getName())) continue;
            return registeredParameter;
        }
        throw new IllegalArgumentException("Unknown parameter registration name [" + name + "]");
    }

    private <P> ParameterRegistrationImplementor<P> locateParameterRegistration(int position) {
        if (this.parameterStrategy == ParameterStrategy.NAMED) {
            throw new IllegalArgumentException("Expecting named parameter");
        }
        for (ParameterRegistrationImplementor<?> registeredParameter : this.registeredParameters) {
            if (registeredParameter.getPosition() == null || registeredParameter.getPosition() != position) continue;
            return registeredParameter;
        }
        throw new IllegalArgumentException("Unknown parameter registration position [" + position + "]");
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(Parameter<P> parameter, P value) {
        this.locateParameterRegistration(parameter).bindValue(value);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(String name, Object value) {
        this.locateParameterRegistration(name).bindValue(value);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(int position, Object value) {
        this.locateParameterRegistration(position).bindValue(value);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(QueryParameter<P> parameter, P value, Type type) {
        ParameterRegistrationImplementor<P> reg = this.locateParameterRegistration(parameter);
        reg.bindValue(value);
        reg.setHibernateType(type);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(String name, Object value, Type type) {
        ParameterRegistrationImplementor reg = this.locateParameterRegistration(name);
        reg.bindValue(value);
        reg.setHibernateType(type);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(int position, Object value, Type type) {
        ParameterRegistrationImplementor reg = this.locateParameterRegistration(position);
        reg.bindValue(value);
        reg.setHibernateType(type);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(QueryParameter<P> parameter, P value, TemporalType temporalType) {
        this.locateParameterRegistration(parameter).bindValue(value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(String name, Object value, TemporalType temporalType) {
        this.locateParameterRegistration(name).bindValue(value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(int position, Object value, TemporalType temporalType) {
        this.locateParameterRegistration(position).bindValue(value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameterList(QueryParameter parameter, Collection values) {
        super.setParameterList(parameter, values);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameterList(String name, Collection values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameterList(String name, Collection values, Type type) {
        super.setParameterList(name, values, type);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameterList(String name, Object[] values, Type type) {
        super.setParameterList(name, values, type);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameterList(String name, Object[] values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(Parameter parameter, Calendar value, TemporalType temporalType) {
        this.locateParameterRegistration(parameter).bindValue(value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(Parameter parameter, Date value, TemporalType temporalType) {
        this.locateParameterRegistration(parameter).bindValue(value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(String name, Calendar value, TemporalType temporalType) {
        this.locateParameterRegistration(name).bindValue(value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(String name, Date value, TemporalType temporalType) {
        this.locateParameterRegistration(name).bindValue(value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(int position, Calendar value, TemporalType temporalType) {
        this.locateParameterRegistration(position).bindValue(value, temporalType);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(int position, Date value, TemporalType temporalType) {
        this.locateParameterRegistration(position).bindValue(value, temporalType);
        return this;
    }
}

