/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.persister.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.MappingException;
import org.evosuite.shaded.org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.evosuite.shaded.org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.evosuite.shaded.org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.evosuite.shaded.org.hibernate.mapping.Collection;
import org.evosuite.shaded.org.hibernate.mapping.PersistentClass;
import org.evosuite.shaded.org.hibernate.persister.collection.CollectionPersister;
import org.evosuite.shaded.org.hibernate.persister.entity.EntityPersister;
import org.evosuite.shaded.org.hibernate.persister.spi.PersisterClassResolver;
import org.evosuite.shaded.org.hibernate.persister.spi.PersisterCreationContext;
import org.evosuite.shaded.org.hibernate.persister.spi.PersisterFactory;
import org.evosuite.shaded.org.hibernate.service.spi.ServiceRegistryAwareService;
import org.evosuite.shaded.org.hibernate.service.spi.ServiceRegistryImplementor;

public final class PersisterFactoryImpl
implements PersisterFactory,
ServiceRegistryAwareService {
    public static final Class[] ENTITY_PERSISTER_CONSTRUCTOR_ARGS = new Class[]{PersistentClass.class, EntityRegionAccessStrategy.class, NaturalIdRegionAccessStrategy.class, PersisterCreationContext.class};
    public static final Class[] COLLECTION_PERSISTER_CONSTRUCTOR_ARGS = new Class[]{Collection.class, CollectionRegionAccessStrategy.class, PersisterCreationContext.class};
    private ServiceRegistryImplementor serviceRegistry;

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public EntityPersister createEntityPersister(PersistentClass entityBinding, EntityRegionAccessStrategy entityCacheAccessStrategy, NaturalIdRegionAccessStrategy naturalIdCacheAccessStrategy, PersisterCreationContext creationContext) throws HibernateException {
        Class<? extends EntityPersister> persisterClass = entityBinding.getEntityPersisterClass();
        if (persisterClass == null) {
            persisterClass = this.serviceRegistry.getService(PersisterClassResolver.class).getEntityPersisterClass(entityBinding);
        }
        return this.createEntityPersister(persisterClass, entityBinding, entityCacheAccessStrategy, naturalIdCacheAccessStrategy, creationContext);
    }

    private EntityPersister createEntityPersister(Class<? extends EntityPersister> persisterClass, PersistentClass entityBinding, EntityRegionAccessStrategy entityCacheAccessStrategy, NaturalIdRegionAccessStrategy naturalIdCacheAccessStrategy, PersisterCreationContext creationContext) {
        try {
            Constructor<? extends EntityPersister> constructor = persisterClass.getConstructor(ENTITY_PERSISTER_CONSTRUCTOR_ARGS);
            try {
                return constructor.newInstance(entityBinding, entityCacheAccessStrategy, naturalIdCacheAccessStrategy, creationContext);
            }
            catch (MappingException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof HibernateException) {
                    throw (HibernateException)target;
                }
                throw new MappingException("Could not instantiate persister " + persisterClass.getName(), target);
            }
            catch (Exception e) {
                throw new MappingException("Could not instantiate persister " + persisterClass.getName(), e);
            }
        }
        catch (MappingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MappingException("Could not get constructor for " + persisterClass.getName(), e);
        }
    }

    @Override
    public CollectionPersister createCollectionPersister(Collection collectionBinding, CollectionRegionAccessStrategy cacheAccessStrategy, PersisterCreationContext creationContext) throws HibernateException {
        Class<? extends CollectionPersister> persisterClass = collectionBinding.getCollectionPersisterClass();
        if (persisterClass == null) {
            persisterClass = this.serviceRegistry.getService(PersisterClassResolver.class).getCollectionPersisterClass(collectionBinding);
        }
        return this.createCollectionPersister(persisterClass, collectionBinding, cacheAccessStrategy, creationContext);
    }

    private CollectionPersister createCollectionPersister(Class<? extends CollectionPersister> persisterClass, Collection collectionBinding, CollectionRegionAccessStrategy cacheAccessStrategy, PersisterCreationContext creationContext) {
        try {
            Constructor<? extends CollectionPersister> constructor = persisterClass.getConstructor(COLLECTION_PERSISTER_CONSTRUCTOR_ARGS);
            try {
                return constructor.newInstance(collectionBinding, cacheAccessStrategy, creationContext);
            }
            catch (MappingException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof HibernateException) {
                    throw (HibernateException)target;
                }
                throw new MappingException("Could not instantiate collection persister " + persisterClass.getName(), target);
            }
            catch (Exception e) {
                throw new MappingException("Could not instantiate collection persister " + persisterClass.getName(), e);
            }
        }
        catch (MappingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MappingException("Could not get constructor for " + persisterClass.getName(), e);
        }
    }
}

