/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.persister.collection;

import java.io.Serializable;
import org.evosuite.shaded.org.hibernate.FlushMode;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.loader.collection.CollectionInitializer;
import org.evosuite.shaded.org.hibernate.persister.collection.CollectionPersister;
import org.evosuite.shaded.org.hibernate.query.NativeQuery;

public final class NamedQueryCollectionInitializer
implements CollectionInitializer {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(NamedQueryCollectionInitializer.class);
    private final String queryName;
    private final CollectionPersister persister;

    public NamedQueryCollectionInitializer(String queryName, CollectionPersister persister) {
        this.queryName = queryName;
        this.persister = persister;
    }

    @Override
    public void initialize(Serializable key, SharedSessionContractImplementor session) throws HibernateException {
        LOG.debugf("Initializing collection: %s using named query: %s", (Object)this.persister.getRole(), (Object)this.queryName);
        NativeQuery nativeQuery = session.getNamedNativeQuery(this.queryName);
        if (nativeQuery.getParameterMetadata().hasNamedParameters()) {
            nativeQuery.setParameter(nativeQuery.getParameterMetadata().getNamedParameterNames().iterator().next(), (Object)key, this.persister.getKeyType());
        } else {
            nativeQuery.setParameter(0, (Object)key, this.persister.getKeyType());
        }
        nativeQuery.setCollectionKey(key).setFlushMode(FlushMode.MANUAL).list();
    }
}

