/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.loader.plan.exec.internal;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.loader.MultipleBagFetchException;
import org.evosuite.shaded.org.hibernate.loader.plan.build.spi.LoadPlanTreePrinter;
import org.evosuite.shaded.org.hibernate.loader.plan.exec.internal.AliasResolutionContextImpl;
import org.evosuite.shaded.org.hibernate.loader.plan.exec.internal.FetchStats;
import org.evosuite.shaded.org.hibernate.loader.plan.exec.internal.LoadQueryJoinAndFetchProcessor;
import org.evosuite.shaded.org.hibernate.loader.plan.exec.process.internal.ResultSetProcessorImpl;
import org.evosuite.shaded.org.hibernate.loader.plan.exec.process.spi.CollectionReferenceInitializer;
import org.evosuite.shaded.org.hibernate.loader.plan.exec.process.spi.EntityReferenceInitializer;
import org.evosuite.shaded.org.hibernate.loader.plan.exec.process.spi.ReaderCollector;
import org.evosuite.shaded.org.hibernate.loader.plan.exec.process.spi.ResultSetProcessor;
import org.evosuite.shaded.org.hibernate.loader.plan.exec.query.internal.SelectStatementBuilder;
import org.evosuite.shaded.org.hibernate.loader.plan.exec.query.spi.QueryBuildingParameters;
import org.evosuite.shaded.org.hibernate.loader.plan.exec.spi.AliasResolutionContext;
import org.evosuite.shaded.org.hibernate.loader.plan.exec.spi.LoadQueryDetails;
import org.evosuite.shaded.org.hibernate.loader.plan.spi.CollectionAttributeFetch;
import org.evosuite.shaded.org.hibernate.loader.plan.spi.CollectionReturn;
import org.evosuite.shaded.org.hibernate.loader.plan.spi.FetchSource;
import org.evosuite.shaded.org.hibernate.loader.plan.spi.LoadPlan;
import org.evosuite.shaded.org.hibernate.loader.plan.spi.QuerySpace;
import org.evosuite.shaded.org.hibernate.loader.plan.spi.Return;
import org.evosuite.shaded.org.hibernate.sql.ConditionFragment;
import org.evosuite.shaded.org.hibernate.sql.DisjunctionFragment;
import org.evosuite.shaded.org.hibernate.sql.InFragment;

public abstract class AbstractLoadQueryDetails
implements LoadQueryDetails {
    private final LoadPlan loadPlan;
    private final String[] keyColumnNames;
    private final Return rootReturn;
    private final LoadQueryJoinAndFetchProcessor queryProcessor;
    private String sqlStatement;
    private ResultSetProcessor resultSetProcessor;

    protected AbstractLoadQueryDetails(LoadPlan loadPlan, AliasResolutionContextImpl aliasResolutionContext, QueryBuildingParameters buildingParameters, String[] keyColumnNames, Return rootReturn, SessionFactoryImplementor factory) {
        this.keyColumnNames = keyColumnNames;
        this.rootReturn = rootReturn;
        this.loadPlan = loadPlan;
        this.queryProcessor = new LoadQueryJoinAndFetchProcessor(aliasResolutionContext, buildingParameters, factory);
    }

    protected QuerySpace getQuerySpace(String querySpaceUid) {
        return this.loadPlan.getQuerySpaces().getQuerySpaceByUid(querySpaceUid);
    }

    @Override
    public String getSqlStatement() {
        return this.sqlStatement;
    }

    @Override
    public ResultSetProcessor getResultSetProcessor() {
        return this.resultSetProcessor;
    }

    protected final Return getRootReturn() {
        return this.rootReturn;
    }

    protected final AliasResolutionContext getAliasResolutionContext() {
        return this.queryProcessor.getAliasResolutionContext();
    }

    protected final QueryBuildingParameters getQueryBuildingParameters() {
        return this.queryProcessor.getQueryBuildingParameters();
    }

    protected final SessionFactoryImplementor getSessionFactory() {
        return this.queryProcessor.getSessionFactory();
    }

    protected void generate() {
        CollectionReturn collectionReturn;
        SelectStatementBuilder select = new SelectStatementBuilder(this.queryProcessor.getSessionFactory().getDialect());
        this.applyRootReturnTableFragments(select);
        if (this.shouldApplyRootReturnFilterBeforeKeyRestriction()) {
            this.applyRootReturnFilterRestrictions(select);
            AbstractLoadQueryDetails.applyKeyRestriction(select, this.getRootTableAlias(), this.keyColumnNames, this.getQueryBuildingParameters().getBatchSize());
        } else {
            AbstractLoadQueryDetails.applyKeyRestriction(select, this.getRootTableAlias(), this.keyColumnNames, this.getQueryBuildingParameters().getBatchSize());
            this.applyRootReturnFilterRestrictions(select);
        }
        this.applyRootReturnWhereJoinRestrictions(select);
        this.applyRootReturnOrderByFragments(select);
        this.applyRootReturnSelectFragments(select);
        this.queryProcessor.processQuerySpaceJoins(this.getRootQuerySpace(), select);
        FetchStats fetchStats = null;
        if (FetchSource.class.isInstance(this.rootReturn)) {
            fetchStats = this.queryProcessor.processFetches((FetchSource)((Object)this.rootReturn), select, this.getReaderCollector());
        } else if (CollectionReturn.class.isInstance(this.rootReturn) && (collectionReturn = (CollectionReturn)this.rootReturn).getElementGraph() != null) {
            fetchStats = this.queryProcessor.processFetches(collectionReturn.getElementGraph(), select, this.getReaderCollector());
        }
        if (fetchStats != null && fetchStats.getJoinedBagAttributeFetches().size() > 1) {
            ArrayList<String> bagRoles = new ArrayList<String>();
            for (CollectionAttributeFetch bagFetch : fetchStats.getJoinedBagAttributeFetches()) {
                bagRoles.add(bagFetch.getCollectionPersister().getRole());
            }
            throw new MultipleBagFetchException(bagRoles);
        }
        LoadPlanTreePrinter.INSTANCE.logTree(this.loadPlan, this.queryProcessor.getAliasResolutionContext());
        this.sqlStatement = select.toStatementString();
        this.resultSetProcessor = new ResultSetProcessorImpl(this.loadPlan, this.queryProcessor.getAliasResolutionContext(), this.getReaderCollector().buildRowReader(), this.shouldUseOptionalEntityInstance(), this.isSubselectLoadingEnabled(fetchStats));
    }

    protected abstract boolean isSubselectLoadingEnabled(FetchStats var1);

    protected abstract boolean shouldUseOptionalEntityInstance();

    protected abstract ReaderCollector getReaderCollector();

    protected abstract QuerySpace getRootQuerySpace();

    protected abstract String getRootTableAlias();

    protected abstract boolean shouldApplyRootReturnFilterBeforeKeyRestriction();

    protected abstract void applyRootReturnSelectFragments(SelectStatementBuilder var1);

    protected abstract void applyRootReturnTableFragments(SelectStatementBuilder var1);

    protected abstract void applyRootReturnFilterRestrictions(SelectStatementBuilder var1);

    protected abstract void applyRootReturnWhereJoinRestrictions(SelectStatementBuilder var1);

    protected abstract void applyRootReturnOrderByFragments(SelectStatementBuilder var1);

    private static void applyKeyRestriction(SelectStatementBuilder select, String alias, String[] keyColumnNames, int batchSize) {
        if (keyColumnNames.length == 1) {
            InFragment in = new InFragment().setColumn(alias, keyColumnNames[0]);
            for (int i = 0; i < batchSize; ++i) {
                in.addValue("?");
            }
            select.appendRestrictions(in.toFragmentString());
        } else {
            ConditionFragment keyRestrictionBuilder = new ConditionFragment().setTableAlias(alias).setCondition(keyColumnNames, "?");
            String keyRestrictionFragment = keyRestrictionBuilder.toFragmentString();
            StringBuilder restrictions = new StringBuilder();
            if (batchSize == 1) {
                restrictions.append(keyRestrictionFragment);
            } else {
                restrictions.append('(');
                DisjunctionFragment df = new DisjunctionFragment();
                for (int i = 0; i < batchSize; ++i) {
                    df.addCondition(keyRestrictionFragment);
                }
                restrictions.append(df.toFragmentString());
                restrictions.append(')');
            }
            select.appendRestrictions(restrictions.toString());
        }
    }

    protected static abstract class ReaderCollectorImpl
    implements ReaderCollector {
        private final List<EntityReferenceInitializer> entityReferenceInitializers = new ArrayList<EntityReferenceInitializer>();
        private List<CollectionReferenceInitializer> arrayReferenceInitializers;
        private List<CollectionReferenceInitializer> collectionReferenceInitializers;

        protected ReaderCollectorImpl() {
        }

        @Override
        public void add(CollectionReferenceInitializer collectionReferenceInitializer) {
            if (collectionReferenceInitializer.getCollectionReference().getCollectionPersister().isArray()) {
                if (this.arrayReferenceInitializers == null) {
                    this.arrayReferenceInitializers = new ArrayList<CollectionReferenceInitializer>();
                }
                this.arrayReferenceInitializers.add(collectionReferenceInitializer);
            } else {
                if (this.collectionReferenceInitializers == null) {
                    this.collectionReferenceInitializers = new ArrayList<CollectionReferenceInitializer>();
                }
                this.collectionReferenceInitializers.add(collectionReferenceInitializer);
            }
        }

        @Override
        public void add(EntityReferenceInitializer entityReferenceInitializer) {
            this.entityReferenceInitializers.add(entityReferenceInitializer);
        }

        @Override
        public final List<EntityReferenceInitializer> getEntityReferenceInitializers() {
            return this.entityReferenceInitializers;
        }

        @Override
        public List<CollectionReferenceInitializer> getArrayReferenceInitializers() {
            return this.arrayReferenceInitializers;
        }

        @Override
        public List<CollectionReferenceInitializer> getNonArrayCollectionReferenceInitializers() {
            return this.collectionReferenceInitializers;
        }
    }
}

