/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.engine.loading.internal;

import java.io.Serializable;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.evosuite.shaded.org.hibernate.collection.spi.PersistentCollection;
import org.evosuite.shaded.org.hibernate.engine.loading.internal.CollectionLoadContext;
import org.evosuite.shaded.org.hibernate.engine.loading.internal.EntityLoadContext;
import org.evosuite.shaded.org.hibernate.engine.loading.internal.LoadingCollectionEntry;
import org.evosuite.shaded.org.hibernate.engine.spi.CollectionKey;
import org.evosuite.shaded.org.hibernate.engine.spi.PersistenceContext;
import org.evosuite.shaded.org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.persister.collection.CollectionPersister;
import org.evosuite.shaded.org.hibernate.pretty.MessageHelper;

public class LoadContexts {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(LoadContexts.class);
    private final PersistenceContext persistenceContext;
    private Map<ResultSet, CollectionLoadContext> collectionLoadContexts;
    private Map<ResultSet, EntityLoadContext> entityLoadContexts;
    private Map<CollectionKey, LoadingCollectionEntry> xrefLoadingCollectionEntries;

    public LoadContexts(PersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    private SharedSessionContractImplementor getSession() {
        return this.getPersistenceContext().getSession();
    }

    public void cleanup(ResultSet resultSet) {
        if (this.collectionLoadContexts != null) {
            CollectionLoadContext collectionLoadContext = this.collectionLoadContexts.remove(resultSet);
            collectionLoadContext.cleanup();
        }
        if (this.entityLoadContexts != null) {
            EntityLoadContext entityLoadContext = this.entityLoadContexts.remove(resultSet);
            entityLoadContext.cleanup();
        }
    }

    public void cleanup() {
        if (this.collectionLoadContexts != null) {
            for (CollectionLoadContext collectionLoadContext : this.collectionLoadContexts.values()) {
                LOG.failSafeCollectionsCleanup(collectionLoadContext);
                collectionLoadContext.cleanup();
            }
            this.collectionLoadContexts.clear();
        }
        if (this.entityLoadContexts != null) {
            for (EntityLoadContext entityLoadContext : this.entityLoadContexts.values()) {
                LOG.failSafeEntitiesCleanup(entityLoadContext);
                entityLoadContext.cleanup();
            }
            this.entityLoadContexts.clear();
        }
    }

    public boolean hasLoadingCollectionEntries() {
        return this.collectionLoadContexts != null && !this.collectionLoadContexts.isEmpty();
    }

    public boolean hasRegisteredLoadingCollectionEntries() {
        return this.xrefLoadingCollectionEntries != null && !this.xrefLoadingCollectionEntries.isEmpty();
    }

    public CollectionLoadContext getCollectionLoadContext(ResultSet resultSet) {
        CollectionLoadContext context = null;
        if (this.collectionLoadContexts == null) {
            this.collectionLoadContexts = new IdentityHashMap<ResultSet, CollectionLoadContext>(8);
        } else {
            context = this.collectionLoadContexts.get(resultSet);
        }
        if (context == null) {
            LOG.tracev("Constructing collection load context for result set [{0}]", (Object)resultSet);
            context = new CollectionLoadContext(this, resultSet);
            this.collectionLoadContexts.put(resultSet, context);
        }
        return context;
    }

    public PersistentCollection locateLoadingCollection(CollectionPersister persister, Serializable ownerKey) {
        LoadingCollectionEntry lce = this.locateLoadingCollectionEntry(new CollectionKey(persister, ownerKey));
        if (lce != null) {
            if (LOG.isTraceEnabled()) {
                LOG.tracef("Returning loading collection: %s", (Object)MessageHelper.collectionInfoString(persister, ownerKey, this.getSession().getFactory()));
            }
            return lce.getCollection();
        }
        return null;
    }

    void registerLoadingCollectionXRef(CollectionKey entryKey, LoadingCollectionEntry entry) {
        if (this.xrefLoadingCollectionEntries == null) {
            this.xrefLoadingCollectionEntries = new HashMap<CollectionKey, LoadingCollectionEntry>();
        }
        this.xrefLoadingCollectionEntries.put(entryKey, entry);
    }

    void unregisterLoadingCollectionXRef(CollectionKey key) {
        if (!this.hasRegisteredLoadingCollectionEntries()) {
            return;
        }
        this.xrefLoadingCollectionEntries.remove(key);
    }

    Map getLoadingCollectionXRefs() {
        return this.xrefLoadingCollectionEntries;
    }

    LoadingCollectionEntry locateLoadingCollectionEntry(CollectionKey key) {
        if (this.xrefLoadingCollectionEntries == null) {
            return null;
        }
        LOG.tracev("Attempting to locate loading collection entry [{0}] in any result-set context", (Object)key);
        LoadingCollectionEntry rtn = this.xrefLoadingCollectionEntries.get(key);
        if (rtn == null) {
            LOG.tracev("Collection [{0}] not located in load context", (Object)key);
        } else {
            LOG.tracev("Collection [{0}] located in load context", (Object)key);
        }
        return rtn;
    }

    void cleanupCollectionXRefs(Set<CollectionKey> entryKeys) {
        for (CollectionKey entryKey : entryKeys) {
            this.xrefLoadingCollectionEntries.remove(entryKey);
        }
    }

    public EntityLoadContext getEntityLoadContext(ResultSet resultSet) {
        EntityLoadContext context = null;
        if (this.entityLoadContexts == null) {
            this.entityLoadContexts = new IdentityHashMap<ResultSet, EntityLoadContext>(8);
        } else {
            context = this.entityLoadContexts.get(resultSet);
        }
        if (context == null) {
            context = new EntityLoadContext(this, resultSet);
            this.entityLoadContexts.put(resultSet, context);
        }
        return context;
    }
}

