/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.engine.jdbc.connections.internal;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.evosuite.shaded.org.hibernate.engine.jdbc.connections.internal.ConnectionCreator;
import org.evosuite.shaded.org.hibernate.engine.jdbc.connections.internal.ConnectionCreatorBuilder;
import org.evosuite.shaded.org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.evosuite.shaded.org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.internal.log.ConnectionPoolingLogger;
import org.evosuite.shaded.org.hibernate.internal.util.config.ConfigurationHelper;
import org.evosuite.shaded.org.hibernate.service.UnknownUnwrapTypeException;
import org.evosuite.shaded.org.hibernate.service.spi.Configurable;
import org.evosuite.shaded.org.hibernate.service.spi.ServiceException;
import org.evosuite.shaded.org.hibernate.service.spi.ServiceRegistryAwareService;
import org.evosuite.shaded.org.hibernate.service.spi.ServiceRegistryImplementor;
import org.evosuite.shaded.org.hibernate.service.spi.Stoppable;

public class DriverManagerConnectionProviderImpl
implements ConnectionProvider,
Configurable,
Stoppable,
ServiceRegistryAwareService {
    private static final ConnectionPoolingLogger log = ConnectionPoolingLogger.CONNECTIONS_LOGGER;
    public static final String MIN_SIZE = "hibernate.connection.min_pool_size";
    public static final String INITIAL_SIZE = "hibernate.connection.initial_pool_size";
    public static final String VALIDATION_INTERVAL = "hibernate.connection.pool_validation_interval";
    private boolean active = true;
    private ScheduledExecutorService executorService;
    private PooledConnections pool;
    private ServiceRegistryImplementor serviceRegistry;

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public void configure(Map configurationValues) {
        log.usingHibernateBuiltInConnectionPool();
        this.pool = this.buildPool(configurationValues);
        long validationInterval = ConfigurationHelper.getLong(VALIDATION_INTERVAL, configurationValues, 30);
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.executorService.scheduleWithFixedDelay(new Runnable(){
            private boolean primed;

            @Override
            public void run() {
                DriverManagerConnectionProviderImpl.this.pool.validate();
            }
        }, validationInterval, validationInterval, TimeUnit.SECONDS);
    }

    private PooledConnections buildPool(Map configurationValues) {
        boolean autoCommit = ConfigurationHelper.getBoolean("hibernate.connection.autocommit", configurationValues, false);
        int minSize = ConfigurationHelper.getInt(MIN_SIZE, configurationValues, 1);
        int maxSize = ConfigurationHelper.getInt("hibernate.connection.pool_size", configurationValues, 20);
        int initialSize = ConfigurationHelper.getInt(INITIAL_SIZE, configurationValues, minSize);
        ConnectionCreator connectionCreator = this.buildCreator(configurationValues);
        PooledConnections.Builder pooledConnectionBuilder = new PooledConnections.Builder(connectionCreator, autoCommit);
        pooledConnectionBuilder.initialSize(initialSize);
        pooledConnectionBuilder.minSize(minSize);
        pooledConnectionBuilder.maxSize(maxSize);
        return pooledConnectionBuilder.build();
    }

    private ConnectionCreator buildCreator(Map configurationValues) {
        ConnectionCreatorBuilder connectionCreatorBuilder = new ConnectionCreatorBuilder(this.serviceRegistry);
        String driverClassName = (String)configurationValues.get("hibernate.connection.driver_class");
        connectionCreatorBuilder.setDriver(this.loadDriverIfPossible(driverClassName));
        String url = (String)configurationValues.get("hibernate.connection.url");
        if (url == null) {
            String msg = log.jdbcUrlNotSpecified("hibernate.connection.url");
            log.error(msg);
            throw new HibernateException(msg);
        }
        connectionCreatorBuilder.setUrl(url);
        log.usingDriver(driverClassName, url);
        Properties connectionProps = ConnectionProviderInitiator.getConnectionProperties(configurationValues);
        if (log.isDebugEnabled()) {
            log.connectionProperties(connectionProps);
        } else {
            log.connectionProperties(ConfigurationHelper.maskOut(connectionProps, "password"));
        }
        connectionCreatorBuilder.setConnectionProps(connectionProps);
        boolean autoCommit = ConfigurationHelper.getBoolean("hibernate.connection.autocommit", configurationValues, false);
        log.autoCommitMode(autoCommit);
        connectionCreatorBuilder.setAutoCommit(autoCommit);
        Integer isolation = ConnectionProviderInitiator.extractIsolation(configurationValues);
        if (isolation != null) {
            log.jdbcIsolationLevel(ConnectionProviderInitiator.toIsolationNiceName(isolation));
        }
        connectionCreatorBuilder.setIsolation(isolation);
        return connectionCreatorBuilder.build();
    }

    private Driver loadDriverIfPossible(String driverClassName) {
        if (driverClassName == null) {
            log.debug("No driver class specified");
            return null;
        }
        if (this.serviceRegistry != null) {
            ClassLoaderService classLoaderService = this.serviceRegistry.getService(ClassLoaderService.class);
            Class driverClass = classLoaderService.classForName(driverClassName);
            try {
                return (Driver)driverClass.newInstance();
            }
            catch (Exception e) {
                throw new ServiceException("Specified JDBC Driver " + driverClassName + " could not be loaded", e);
            }
        }
        try {
            return (Driver)Class.forName(driverClassName).newInstance();
        }
        catch (Exception e1) {
            throw new ServiceException("Specified JDBC Driver " + driverClassName + " could not be loaded", e1);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (!this.active) {
            throw new HibernateException("Connection pool is no longer active");
        }
        return this.pool.poll();
    }

    @Override
    public void closeConnection(Connection conn) throws SQLException {
        if (conn == null) {
            return;
        }
        this.pool.add(conn);
    }

    @Override
    public boolean supportsAggressiveRelease() {
        return false;
    }

    @Override
    public boolean isUnwrappableAs(Class unwrapType) {
        return ConnectionProvider.class.equals((Object)unwrapType) || DriverManagerConnectionProviderImpl.class.isAssignableFrom(unwrapType);
    }

    @Override
    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || DriverManagerConnectionProviderImpl.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    @Override
    public void stop() {
        if (!this.active) {
            return;
        }
        log.cleaningUpConnectionPool(this.pool.getUrl());
        this.active = false;
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        this.executorService = null;
        try {
            this.pool.close();
        }
        catch (SQLException e) {
            log.unableToClosePooledConnection(e);
        }
    }

    protected void finalize() throws Throwable {
        if (this.active) {
            this.stop();
        }
        super.finalize();
    }

    public static class PooledConnections {
        private final ConcurrentLinkedQueue<Connection> allConnections = new ConcurrentLinkedQueue();
        private final ConcurrentLinkedQueue<Connection> availableConnections = new ConcurrentLinkedQueue();
        private static final CoreMessageLogger log = CoreLogging.messageLogger(DriverManagerConnectionProviderImpl.class);
        private final ConnectionCreator connectionCreator;
        private final boolean autoCommit;
        private final int minSize;
        private final int maxSize;
        private boolean primed;

        private PooledConnections(Builder builder) {
            log.debugf("Initializing Connection pool with %s Connections", builder.initialSize);
            this.connectionCreator = builder.connectionCreator;
            this.autoCommit = builder.autoCommit;
            this.maxSize = builder.maxSize;
            this.minSize = builder.minSize;
            log.hibernateConnectionPoolSize(this.maxSize, this.minSize);
            this.addConnections(builder.initialSize);
        }

        public void validate() {
            int size = this.size();
            if (!this.primed && size >= this.minSize) {
                log.debug("Connection pool now considered primed; min-size will be maintained");
                this.primed = true;
            }
            if (size < this.minSize && this.primed) {
                int numberToBeAdded = this.minSize - size;
                log.debugf("Adding %s Connections to the pool", numberToBeAdded);
                this.addConnections(numberToBeAdded);
            } else if (size > this.maxSize) {
                int numberToBeRemoved = size - this.maxSize;
                log.debugf("Removing %s Connections from the pool", numberToBeRemoved);
                this.removeConnections(numberToBeRemoved);
            }
        }

        public void add(Connection conn) throws SQLException {
            conn.setAutoCommit(true);
            conn.clearWarnings();
            this.availableConnections.offer(conn);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Connection poll() throws SQLException {
            Connection conn = this.availableConnections.poll();
            if (conn == null) {
                ConcurrentLinkedQueue<Connection> concurrentLinkedQueue = this.allConnections;
                synchronized (concurrentLinkedQueue) {
                    if (this.allConnections.size() < this.maxSize) {
                        this.addConnections(1);
                        return this.poll();
                    }
                }
                throw new HibernateException("The internal connection pool has reached its maximum size and no connection is currently available!");
            }
            conn.setAutoCommit(this.autoCommit);
            return conn;
        }

        public void close() throws SQLException {
            try {
                int allocationCount = this.allConnections.size() - this.availableConnections.size();
                if (allocationCount > 0) {
                    log.error("Connection leak detected: there are " + allocationCount + " unclosed connections upon shutting down pool " + this.getUrl());
                }
            }
            finally {
                for (Connection connection : this.allConnections) {
                    connection.close();
                }
            }
        }

        public int size() {
            return this.availableConnections.size();
        }

        protected void removeConnections(int numberToBeRemoved) {
            for (int i = 0; i < numberToBeRemoved; ++i) {
                Connection connection = this.availableConnections.poll();
                try {
                    if (connection != null) {
                        connection.close();
                    }
                    this.allConnections.remove(connection);
                    continue;
                }
                catch (SQLException e) {
                    log.unableToCloseConnection(e);
                }
            }
        }

        protected void addConnections(int numberOfConnections) {
            for (int i = 0; i < numberOfConnections; ++i) {
                Connection connection = this.connectionCreator.createConnection();
                this.allConnections.add(connection);
                this.availableConnections.add(connection);
            }
        }

        public String getUrl() {
            return this.connectionCreator.getUrl();
        }

        public static class Builder {
            private final ConnectionCreator connectionCreator;
            private boolean autoCommit;
            private int initialSize = 1;
            private int minSize = 1;
            private int maxSize = 20;

            public Builder(ConnectionCreator connectionCreator, boolean autoCommit) {
                this.connectionCreator = connectionCreator;
                this.autoCommit = autoCommit;
            }

            public Builder initialSize(int initialSize) {
                this.initialSize = initialSize;
                return this;
            }

            public Builder minSize(int minSize) {
                this.minSize = minSize;
                return this;
            }

            public Builder maxSize(int maxSize) {
                this.maxSize = maxSize;
                return this;
            }

            public PooledConnections build() {
                return new PooledConnections(this);
            }
        }
    }
}

