/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.dialect;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.evosuite.shaded.org.hibernate.MappingException;
import org.evosuite.shaded.org.hibernate.internal.util.StringHelper;

public class TypeNames {
    private Map<Integer, String> defaults = new HashMap<Integer, String>();
    private Map<Integer, Map<Long, String>> weighted = new HashMap<Integer, Map<Long, String>>();

    public String get(int typeCode) throws MappingException {
        String result = this.defaults.get(typeCode);
        if (result == null) {
            throw new MappingException("No Dialect mapping for JDBC type: " + typeCode);
        }
        return result;
    }

    public String get(int typeCode, long size, int precision, int scale) throws MappingException {
        Map<Long, String> map = this.weighted.get(typeCode);
        if (map != null && map.size() > 0) {
            for (Map.Entry<Long, String> entry : map.entrySet()) {
                if (size > entry.getKey()) continue;
                return TypeNames.replace(entry.getValue(), size, precision, scale);
            }
        }
        return TypeNames.replace(this.get(typeCode), size, precision, scale);
    }

    private static String replace(String type, long size, int precision, int scale) {
        type = StringHelper.replaceOnce(type, "$s", Integer.toString(scale));
        type = StringHelper.replaceOnce(type, "$l", Long.toString(size));
        return StringHelper.replaceOnce(type, "$p", Integer.toString(precision));
    }

    public void put(int typeCode, long capacity, String value) {
        Map<Long, String> map = this.weighted.get(typeCode);
        if (map == null) {
            map = new TreeMap<Long, String>();
            this.weighted.put(typeCode, map);
        }
        map.put(capacity, value);
    }

    public void put(int typeCode, String value) {
        this.defaults.put(typeCode, value);
    }

    public boolean containsTypeName(String typeName) {
        return this.defaults.containsValue(typeName);
    }
}

