/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.dialect;

import java.sql.PreparedStatement;
import org.evosuite.shaded.org.hibernate.dialect.AbstractHANADialect;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.DeleteStatement;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.FromElement;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.UpdateStatement;
import org.evosuite.shaded.org.hibernate.hql.spi.id.IdTableInfo;
import org.evosuite.shaded.org.hibernate.hql.spi.id.IdTableSupportStandardImpl;
import org.evosuite.shaded.org.hibernate.hql.spi.id.MultiTableBulkIdStrategy;
import org.evosuite.shaded.org.hibernate.hql.spi.id.TableBasedDeleteHandlerImpl;
import org.evosuite.shaded.org.hibernate.hql.spi.id.TableBasedUpdateHandlerImpl;
import org.evosuite.shaded.org.hibernate.hql.spi.id.global.GlobalTemporaryTableBulkIdStrategy;
import org.evosuite.shaded.org.hibernate.hql.spi.id.local.AfterUseAction;
import org.evosuite.shaded.org.hibernate.persister.entity.Queryable;

public class HANAColumnStoreDialect
extends AbstractHANADialect {
    @Override
    public String getCreateTableString() {
        return "create column table";
    }

    @Override
    public MultiTableBulkIdStrategy getDefaultMultiTableBulkIdStrategy() {
        return new GlobalTemporaryTableBulkIdStrategy(new IdTableSupportStandardImpl(){

            @Override
            public String getCreateIdTableCommand() {
                return "create global temporary column table";
            }
        }, AfterUseAction.CLEAN){

            @Override
            public MultiTableBulkIdStrategy.DeleteHandler buildDeleteHandler(SessionFactoryImplementor factory, HqlSqlWalker walker) {
                DeleteStatement updateStatement = (DeleteStatement)walker.getAST();
                FromElement fromElement = updateStatement.getFromClause().getFromElement();
                Queryable targetedPersister = fromElement.getQueryable();
                return new TableBasedDeleteHandlerImpl(factory, walker, (IdTableInfo)this.getIdTableInfo(targetedPersister)){

                    @Override
                    protected void releaseFromUse(Queryable persister, SharedSessionContractImplementor session) {
                        this.cleanUpRows(this.getIdTableInfo(persister).getQualifiedIdTableName(), session);
                    }
                };
            }

            @Override
            public MultiTableBulkIdStrategy.UpdateHandler buildUpdateHandler(SessionFactoryImplementor factory, HqlSqlWalker walker) {
                UpdateStatement updateStatement = (UpdateStatement)walker.getAST();
                FromElement fromElement = updateStatement.getFromClause().getFromElement();
                Queryable targetedPersister = fromElement.getQueryable();
                return new TableBasedUpdateHandlerImpl(factory, walker, (IdTableInfo)this.getIdTableInfo(targetedPersister)){

                    @Override
                    protected void releaseFromUse(Queryable persister, SharedSessionContractImplementor session) {
                        this.cleanUpRows(this.getIdTableInfo(persister).getQualifiedIdTableName(), session);
                    }
                };
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void cleanUpRows(String tableName, SharedSessionContractImplementor session) {
                String sql = "truncate table " + tableName;
                PreparedStatement ps = null;
                try {
                    ps = session.getJdbcCoordinator().getStatementPreparer().prepareStatement(sql, false);
                    session.getJdbcCoordinator().getResultSetReturn().executeUpdate(ps);
                }
                finally {
                    if (ps != null) {
                        try {
                            session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(ps);
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        };
    }
}

