/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.bytecode.enhance.internal.javassist;

import org.evosuite.shaded.javassist.CannotCompileException;
import org.evosuite.shaded.javassist.CtClass;
import org.evosuite.shaded.javassist.CtField;
import org.evosuite.shaded.javassist.CtMethod;
import org.evosuite.shaded.javassist.CtNewMethod;
import org.evosuite.shaded.javassist.NotFoundException;
import org.evosuite.shaded.javassist.bytecode.ConstPool;
import org.evosuite.shaded.org.hibernate.bytecode.enhance.spi.EnhancementException;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;

public class MethodWriter {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(MethodWriter.class);

    private MethodWriter() {
    }

    public static CtMethod write(CtClass target, String format, Object ... args) throws CannotCompileException {
        String body = String.format(format, args);
        log.debugf("writing method into [%s]:%n%s", (Object)target.getName(), (Object)body);
        CtMethod method = CtNewMethod.make(body, target);
        target.addMethod(method);
        return method;
    }

    public static CtMethod addGetter(CtClass target, String field, String name) {
        CtField actualField = null;
        try {
            actualField = target.getField(field);
            log.debugf("Writing getter method [%s] into [%s] for field [%s]", (Object)name, (Object)target.getName(), (Object)field);
            CtMethod method = CtNewMethod.getter(name, target.getField(field));
            target.addMethod(method);
            return method;
        }
        catch (CannotCompileException cce) {
            try {
                CtMethod method = CtNewMethod.delegator(CtNewMethod.getter(name, actualField), target);
                target.addMethod(method);
                return method;
            }
            catch (CannotCompileException ignored) {
                String msg = String.format("Could not enhance class [%s] to add method [%s] for field [%s]", target.getName(), name, field);
                throw new EnhancementException(msg, cce);
            }
        }
        catch (NotFoundException nfe) {
            String msg = String.format("Could not enhance class [%s] to add method [%s] for field [%s]", target.getName(), name, field);
            throw new EnhancementException(msg, nfe);
        }
    }

    public static CtMethod addSetter(CtClass target, String field, String name) {
        CtField actualField = null;
        try {
            actualField = target.getField(field);
            log.debugf("Writing setter method [%s] into [%s] for field [%s]", (Object)name, (Object)target.getName(), (Object)field);
            CtMethod method = CtNewMethod.setter(name, actualField);
            target.addMethod(method);
            return method;
        }
        catch (CannotCompileException cce) {
            try {
                CtMethod method = CtNewMethod.delegator(CtNewMethod.setter(name, actualField), target);
                target.addMethod(method);
                return method;
            }
            catch (CannotCompileException ignored) {
                String msg = String.format("Could not enhance class [%s] to add method [%s] for field [%s]", target.getName(), name, field);
                throw new EnhancementException(msg, cce);
            }
        }
        catch (NotFoundException nfe) {
            String msg = String.format("Could not enhance class [%s] to add method [%s] for field [%s]", target.getName(), name, field);
            throw new EnhancementException(msg, nfe);
        }
    }

    public static int addMethod(ConstPool cPool, CtMethod method) {
        return cPool.addMethodrefInfo(cPool.getThisClassInfo(), method.getName(), method.getSignature());
    }
}

